/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc;

import io.nanovc.AreaEntry;
import io.nanovc.RepoPath;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.areas.StringLinkedHashMapArea;
import io.nanovc.content.StringContent;
import java.time.Instant;

public class CommitTags
extends StringLinkedHashMapArea {
    public static CommitTags with() {
        return new CommitTags();
    }

    public static CommitTags none() {
        return new CommitTags();
    }

    public static CommitTags with(String pathToTag, String value) {
        return new CommitTags().and(pathToTag, value);
    }

    public static CommitTags with(RepoPath pathToTag, String value) {
        return new CommitTags().and(pathToTag, value);
    }

    public static CommitTags with(StringAreaAPI otherTags) {
        CommitTags commitTags = new CommitTags();
        for (AreaEntry otherTag : otherTags) {
            commitTags.putString(otherTag.path, ((StringContent)otherTag.content).getValue());
        }
        return commitTags;
    }

    public static CommitTags withAuthor(String author) {
        return new CommitTags().author(author);
    }

    public static CommitTags withAuthorAndTimestamp(String author, TimestampAPI timestamp) {
        return new CommitTags().author(author).authorTimestamp(timestamp);
    }

    public static CommitTags withAuthorAndTimestamp(String author, Instant timestamp) {
        return new CommitTags().author(author).authorTimestamp(timestamp);
    }

    public static CommitTags withCommitter(String committer) {
        return new CommitTags().committer(committer);
    }

    public static CommitTags withCommitterAndTimestamp(String committer, TimestampAPI timestamp) {
        return new CommitTags().committer(committer).committerTimestamp(timestamp);
    }

    public static CommitTags withCommitterAndTimestamp(String committer, Instant timestamp) {
        return new CommitTags().committer(committer).committerTimestamp(timestamp);
    }

    public static CommitTags withAuthorAndCommitter(String authorAndCommitter) {
        return new CommitTags().author(authorAndCommitter).committer(authorAndCommitter);
    }

    public static CommitTags withAuthorCommitterAndTimestamp(String authorAndCommitter, TimestampAPI timestamp) {
        return new CommitTags().author(authorAndCommitter).authorTimestamp(timestamp).committer(authorAndCommitter).committerTimestamp(timestamp);
    }

    public static CommitTags withAuthorCommitterAndTimestamp(String authorAndCommitter, Instant timestamp) {
        return new CommitTags().author(authorAndCommitter).authorTimestamp(timestamp).committer(authorAndCommitter).committerTimestamp(timestamp);
    }

    public static CommitTags withAuthorAndCommitter(String author, String committer) {
        return new CommitTags().author(author).committer(committer);
    }

    public static CommitTags withAuthorCommitterAndTimestamp(String author, String committer, TimestampAPI timestamp) {
        return new CommitTags().author(author).authorTimestamp(timestamp).committer(committer).committerTimestamp(timestamp);
    }

    public static CommitTags withAuthorCommitterAndTimestamp(String author, String committer, Instant timestamp) {
        return new CommitTags().author(author).authorTimestamp(timestamp).committer(committer).committerTimestamp(timestamp);
    }

    public static CommitTags withDescription(String description) {
        return new CommitTags().description(description);
    }

    public CommitTags author(String author) {
        this.putString("/author", author);
        return this;
    }

    public CommitTags authorTimestamp(TimestampAPI timestamp) {
        this.putString("/author/timestamp", timestamp.getInstant().toString());
        return this;
    }

    public CommitTags authorTimestamp(Instant timestamp) {
        this.putString("/author/timestamp", timestamp.toString());
        return this;
    }

    public CommitTags committer(String committer) {
        this.putString("/committer", committer);
        return this;
    }

    public CommitTags committerTimestamp(TimestampAPI timestamp) {
        this.putString("/committer/timestamp", timestamp.getInstant().toString());
        return this;
    }

    public CommitTags committerTimestamp(Instant timestamp) {
        this.putString("/committer/timestamp", timestamp.toString());
        return this;
    }

    public CommitTags description(String description) {
        this.putString("/description", description);
        return this;
    }

    public CommitTags and(String pathToTag, String value) {
        this.putString(pathToTag, value);
        return this;
    }

    public CommitTags and(RepoPath pathToTag, String value) {
        this.putString(pathToTag, value);
        return this;
    }

    public CommitTags and(StringAreaAPI otherTags) {
        for (AreaEntry otherTag : otherTags) {
            this.putString(otherTag.path, ((StringContent)otherTag.content).getValue());
        }
        return this;
    }

    public static class CommonPaths {
        public static final String TIMESTAMP_PATH = "/timestamp";
        public static final String AUTHOR_PATH = "/author";
        public static final String AUTHOR_TIMESTAMP_PATH = "/author/timestamp";
        public static final String COMMITTER_PATH = "/committer";
        public static final String COMMITTER_TIMESTAMP_PATH = "/committer/timestamp";
        public static final String DESCRIPTION_PATH = "/description";
    }
}

