/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc;

import io.nanovc.ContentAPI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public abstract class ContentBase
implements ContentAPI {
    @Override
    public byte[] asByteArray() {
        return this.cloneContentAsByteArray();
    }

    @Override
    public List<Byte> asByteList() {
        return this.cloneContentAsByteList();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.cloneContentAsByteBuffer();
    }

    @Override
    public Stream<Byte> asByteStream() {
        return this.cloneContentAsByteStream();
    }

    public String toString() {
        String contentString;
        byte[] content = this.asByteArray();
        if (content == null) {
            return "0 bytes";
        }
        int contentLength = content.length;
        if (contentLength > 1000) {
            byte[] shortContent = Arrays.copyOf(content, 1000);
            contentString = new String(shortContent);
        } else {
            contentString = new String(content);
        }
        return String.format("%,d byte%s:\n%s", contentLength, contentLength == 1 ? "" : "s", contentString);
    }
}

