/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc;

import io.nanovc.PathAPI;
import java.util.Arrays;
import java.util.Objects;

public abstract class PathBase<TSelf extends PathAPI<TSelf>>
implements PathAPI<TSelf> {
    public static final String DELIMITER = "/";
    public final String path;

    public PathBase(String relativeOrAbsolutePath) {
        this.path = relativeOrAbsolutePath;
    }

    protected abstract TSelf createInstance(String var1);

    @Override
    public TSelf resolve(String relativeOrAbsolutePath) {
        if (PathBase.isAbsolute(relativeOrAbsolutePath)) {
            return this.createInstance(relativeOrAbsolutePath);
        }
        if (PathBase.hasEndingDelimiter(this.path)) {
            return this.createInstance(this.path + relativeOrAbsolutePath);
        }
        return this.createInstance(String.join((CharSequence)DELIMITER, this.path, relativeOrAbsolutePath));
    }

    @Override
    public TSelf ensureEndsWithDelimiter() {
        if (PathBase.hasEndingDelimiter(this.path)) {
            return (TSelf)this;
        }
        return this.createInstance(this.path + DELIMITER);
    }

    @Override
    public TSelf toAbsolutePath() {
        if (PathBase.isAbsolute(this.path)) {
            return (TSelf)this;
        }
        return this.createInstance(DELIMITER + this.path);
    }

    public String toString() {
        return this.path == null ? "" : this.path;
    }

    @Override
    public String[] splitIntoParts() {
        String[] parts = this.path.split(DELIMITER);
        String[] cleanParts = (String[])Arrays.stream(parts).filter(part -> part != null && !part.isEmpty()).toArray(String[]::new);
        return cleanParts;
    }

    static boolean isAbsolute(String relativeOrAbsolutePath) {
        return relativeOrAbsolutePath != null && !relativeOrAbsolutePath.isEmpty() && relativeOrAbsolutePath.startsWith(DELIMITER);
    }

    static boolean hasEndingDelimiter(String relativeOrAbsolutePath) {
        return relativeOrAbsolutePath != null && !relativeOrAbsolutePath.isEmpty() && relativeOrAbsolutePath.endsWith(DELIMITER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathBase)) {
            return false;
        }
        PathBase pathBase = (PathBase)o;
        return Objects.equals(this.path, pathBase.path);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

