/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc;

import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.PathAPI;
import io.nanovc.PatternAPI;
import io.nanovc.RepoPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class PatternBase<TSelf extends PatternAPI<TSelf, TPath>, TPath extends PathAPI<TPath>>
implements PatternAPI<TSelf, TPath> {
    protected final String globPattern;
    protected final Pattern regex;

    public PatternBase(String globPattern) {
        this.globPattern = globPattern;
        this.regex = PatternBase.createRegex(globPattern);
    }

    @Override
    public <T extends ContentAPI> List<AreaEntry<T>> match(Collection<AreaEntry<T>> contentToSearch) {
        ArrayList<AreaEntry<T>> matchedContent = new ArrayList<AreaEntry<T>>();
        for (AreaEntry<T> entry : contentToSearch) {
            Matcher matcher = this.regex.matcher(((RepoPath)entry.path.toAbsolutePath()).path);
            if (!matcher.matches()) continue;
            matchedContent.add(entry);
        }
        return matchedContent;
    }

    @Override
    public <T extends ContentAPI> boolean matches(AreaEntry<T> areaEntryToCheck) {
        Matcher matcher = this.regex.matcher(((RepoPath)areaEntryToCheck.path.toAbsolutePath()).path);
        return matcher.matches();
    }

    @Override
    public boolean matches(TPath path) {
        Matcher matcher = this.regex.matcher(path.toAbsolutePath().toString());
        return matcher.matches();
    }

    @Override
    public boolean matches(String absolutePath) {
        Matcher matcher = this.regex.matcher(absolutePath);
        return matcher.matches();
    }

    @Override
    public <T extends ContentAPI> Stream<AreaEntry<T>> matchStream(Stream<AreaEntry<T>> contentToSearch) {
        return contentToSearch.filter(areaEntry -> {
            Matcher matcher = this.regex.matcher(((RepoPath)areaEntry.path.toAbsolutePath()).path);
            return matcher.matches();
        });
    }

    @Override
    public TSelf or(String otherPattern) {
        return this.createInstance(String.format("(%s)|(%s)", this.globPattern, otherPattern));
    }

    @Override
    public TSelf and(String otherPattern) {
        return this.createInstance(String.format("(%s)(%s)", this.globPattern, otherPattern));
    }

    @Override
    public Pattern asRegex() {
        return this.regex;
    }

    protected abstract TSelf createInstance(String var1);

    public static Pattern createRegex(String globPattern) {
        if (globPattern == null || globPattern.isEmpty()) {
            return Pattern.compile("");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = globPattern.length();
        int lastIndex = length - 1;
        for (int index = 0; index < length; ++index) {
            char currentChar = globPattern.charAt(index);
            if (currentChar == '*') {
                char nextChar;
                if (index < lastIndex && (nextChar = globPattern.charAt(index + 1)) == '*') {
                    ++index;
                    stringBuilder.append(".*");
                    continue;
                }
                stringBuilder.append("[^\\");
                stringBuilder.append("/");
                stringBuilder.append("]");
                stringBuilder.append("*");
                continue;
            }
            if (currentChar == '.') {
                stringBuilder.append("\\.");
                continue;
            }
            stringBuilder.append(currentChar);
        }
        if (!stringBuilder.substring(0, "/".length()).equals("/")) {
            stringBuilder.insert(0, "/");
        }
        return Pattern.compile(stringBuilder.toString());
    }
}

