/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.areas;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import io.nanovc.areas.ByteArrayAreaAPI;
import io.nanovc.areas.LinkedHashMapArea;
import io.nanovc.content.ByteArrayContent;

public class ByteArrayTreeMapArea
extends LinkedHashMapArea<ByteArrayContent>
implements ByteArrayAreaAPI {
    protected ByteArrayContent createContentFor(byte[] bytes) {
        return new ByteArrayContent(bytes);
    }

    @Override
    public void putBytes(RepoPath path, byte[] bytes) {
        this.put(((RepoPath)path.toAbsolutePath()).path, this.createContentFor(bytes));
    }

    @Override
    public void putBytes(String absolutePath, byte[] bytes) {
        this.put(absolutePath, this.createContentFor(bytes));
    }

    @Override
    public byte[] getBytes(RepoPath path) {
        ByteArrayContent content = (ByteArrayContent)this.get(((RepoPath)path.toAbsolutePath()).path);
        return content == null ? null : content.bytes;
    }

    @Override
    public byte[] getBytes(String absolutePath) {
        ByteArrayContent content = (ByteArrayContent)this.get(absolutePath);
        return content == null ? null : content.bytes;
    }

    public static ByteArrayTreeMapArea castOrClone(AreaAPI<? extends ContentAPI> area) {
        if (area instanceof ByteArrayTreeMapArea) {
            return (ByteArrayTreeMapArea)area;
        }
        ByteArrayTreeMapArea clone = new ByteArrayTreeMapArea();
        for (AreaEntry areaEntry : area) {
            clone.putContent(areaEntry.path, new ByteArrayContent(areaEntry.content.asByteArray()));
        }
        return clone;
    }
}

