/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.areas;

import io.nanovc.AreaEntry;
import io.nanovc.RepoPath;
import io.nanovc.areas.EncodedStringAreaAPI;
import io.nanovc.areas.LinkedHashMapArea;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.content.EncodedStringContent;
import io.nanovc.content.StringContent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class EncodedStringLinkedHashMapArea
extends LinkedHashMapArea<EncodedStringContent>
implements EncodedStringAreaAPI {
    public final Charset charset;

    public EncodedStringLinkedHashMapArea(Charset charset) {
        this.charset = charset;
    }

    public EncodedStringLinkedHashMapArea() {
        this(StandardCharsets.UTF_8);
    }

    protected EncodedStringContent createContentFor(String value) {
        return new EncodedStringContent(value, this.charset);
    }

    @Override
    public void putString(RepoPath path, String content) {
        this.put(((RepoPath)path.toAbsolutePath()).path, this.createContentFor(content));
    }

    @Override
    public void putString(String absolutePath, String content) {
        this.put(absolutePath, this.createContentFor(content));
    }

    @Override
    public String getString(RepoPath path) {
        EncodedStringContent content = (EncodedStringContent)this.get(((RepoPath)path.toAbsolutePath()).path);
        return content == null ? null : content.value;
    }

    @Override
    public String getString(String absolutePath) {
        EncodedStringContent content = (EncodedStringContent)this.get(absolutePath);
        return content == null ? null : content.value;
    }

    public static EncodedStringLinkedHashMapArea fromStringArea(StringAreaAPI stringArea) {
        EncodedStringLinkedHashMapArea area = new EncodedStringLinkedHashMapArea();
        for (AreaEntry areaEntry : stringArea) {
            area.putString(areaEntry.path, ((StringContent)areaEntry.content).value);
        }
        return area;
    }
}

