/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.areas;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class LinkedHashMapArea<TContent extends ContentAPI>
extends LinkedHashMap<String, TContent>
implements AreaAPI<TContent> {
    @Override
    public void putContent(RepoPath path, TContent content) {
        this.put(((RepoPath)path.toAbsolutePath()).path, content);
    }

    @Override
    public void putContent(String absolutePath, TContent content) {
        this.put(absolutePath, content);
    }

    @Override
    public TContent getContent(RepoPath path) {
        return (TContent)((ContentAPI)this.get(((RepoPath)path.toAbsolutePath()).path));
    }

    @Override
    public TContent getContent(String absolutePath) {
        return (TContent)((ContentAPI)this.get(absolutePath));
    }

    @Override
    public void removeContent(RepoPath path) {
        this.remove(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public void removeContent(String absolutePath) {
        this.remove(absolutePath);
    }

    @Override
    public void replaceAllContent(Stream<AreaEntry<TContent>> commitContent) {
        this.clear();
        commitContent.forEach((? super T areaEntry) -> this.putContent(areaEntry.path, areaEntry.content));
    }

    @Override
    public Iterator<AreaEntry<TContent>> iterator() {
        return new Iterator<AreaEntry<TContent>>(){
            private final Iterator<Map.Entry<String, TContent>> entrySetIterator;
            {
                this.entrySetIterator = LinkedHashMapArea.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entrySetIterator.hasNext();
            }

            @Override
            public AreaEntry<TContent> next() {
                Map.Entry nextEntry = this.entrySetIterator.next();
                return new AreaEntry<ContentAPI>(RepoPath.at(nextEntry.getKey()), (ContentAPI)nextEntry.getValue());
            }
        };
    }

    @Override
    public boolean hasAnyContent() {
        return this.size() > 0;
    }

    @Override
    public boolean hasContent(RepoPath path) {
        return this.containsKey(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public boolean hasContent(String absolutePath) {
        return this.containsKey(absolutePath);
    }

    @Override
    public Stream<AreaEntry<ContentAPI>> getContentStream() {
        return this.entrySet().stream().map(entry -> new AreaEntry<ContentAPI>(RepoPath.at((String)entry.getKey()), (ContentAPI)entry.getValue()));
    }

    @Override
    public Stream<AreaEntry<TContent>> getTypedContentStream() {
        return this.entrySet().stream().map(entry -> new AreaEntry<ContentAPI>(RepoPath.at((String)entry.getKey()), (ContentAPI)entry.getValue()));
    }
}

