/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.areas;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MapArea<TContent extends ContentAPI>
implements Map<String, TContent>,
AreaAPI<TContent> {
    private final Map<String, TContent> map;

    public MapArea(Map<String, TContent> mapToWrap) {
        this.map = mapToWrap;
    }

    @Override
    public void putContent(RepoPath path, TContent content) {
        this.put(((RepoPath)path.toAbsolutePath()).path, content);
    }

    @Override
    public void putContent(String absolutePath, TContent content) {
        this.put(absolutePath, content);
    }

    @Override
    public TContent getContent(RepoPath path) {
        return (TContent)this.get(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public TContent getContent(String absolutePath) {
        return (TContent)this.get(absolutePath);
    }

    @Override
    public void removeContent(RepoPath path) {
        this.remove(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public void removeContent(String absolutePath) {
        this.remove(absolutePath);
    }

    @Override
    public void replaceAllContent(Stream<AreaEntry<TContent>> commitContent) {
        this.clear();
        commitContent.forEach((? super T areaEntry) -> this.putContent(areaEntry.path, areaEntry.content));
    }

    @Override
    public Iterator<AreaEntry<TContent>> iterator() {
        return new Iterator<AreaEntry<TContent>>(){
            private final Iterator<Map.Entry<String, TContent>> entrySetIterator;
            {
                this.entrySetIterator = MapArea.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entrySetIterator.hasNext();
            }

            @Override
            public AreaEntry<TContent> next() {
                Map.Entry nextEntry = this.entrySetIterator.next();
                return new AreaEntry<ContentAPI>(RepoPath.at(nextEntry.getKey()), (ContentAPI)nextEntry.getValue());
            }
        };
    }

    @Override
    public boolean hasAnyContent() {
        return this.size() > 0;
    }

    @Override
    public boolean hasContent(RepoPath path) {
        return this.containsKey(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public boolean hasContent(String absolutePath) {
        return this.containsKey(absolutePath);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public TContent get(Object key) {
        return (TContent)((ContentAPI)this.map.get(key));
    }

    @Override
    public TContent put(String key, TContent value) {
        return (TContent)((ContentAPI)this.map.put(key, value));
    }

    @Override
    public TContent remove(Object key) {
        return (TContent)((ContentAPI)this.map.remove(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends TContent> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<TContent> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, TContent>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Stream<AreaEntry<ContentAPI>> getContentStream() {
        return this.entrySet().stream().map(entry -> new AreaEntry<ContentAPI>(RepoPath.at((String)entry.getKey()), (ContentAPI)entry.getValue()));
    }

    @Override
    public Stream<AreaEntry<TContent>> getTypedContentStream() {
        return this.entrySet().stream().map(entry -> new AreaEntry<ContentAPI>(RepoPath.at((String)entry.getKey()), (ContentAPI)entry.getValue()));
    }
}

