/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.areas;

import io.nanovc.AreaBase;
import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class SingleContentArea<TContent extends ContentAPI>
extends AreaBase<TContent> {
    private TContent content;
    private RepoPath absolutePath;

    @Override
    public void putContent(RepoPath path, TContent content) {
        this.content = content;
        this.absolutePath = (RepoPath)path.toAbsolutePath();
    }

    @Override
    public void putContent(String absolutePath, TContent content) {
        this.content = content;
        this.absolutePath = RepoPath.at(absolutePath);
    }

    @Override
    public TContent getContent(RepoPath path) {
        return Objects.equals(this.absolutePath, path) ? (TContent)this.content : null;
    }

    @Override
    public TContent getContent(String absolutePath) {
        return this.absolutePath == null ? null : (Objects.equals(this.absolutePath.path, absolutePath) ? this.content : null);
    }

    public TContent getContent() {
        return this.content;
    }

    @Override
    public void removeContent(RepoPath path) {
        if (Objects.equals(this.absolutePath, path)) {
            this.content = null;
            this.absolutePath = null;
        }
    }

    @Override
    public void removeContent(String absolutePath) {
        if (this.absolutePath != null && Objects.equals(this.absolutePath.path, absolutePath)) {
            this.content = null;
            this.absolutePath = null;
        }
    }

    @Override
    public boolean hasAnyContent() {
        return this.content != null;
    }

    @Override
    public boolean hasContent(RepoPath path) {
        return Objects.equals(this.absolutePath, path);
    }

    @Override
    public boolean hasContent(String absolutePath) {
        return this.absolutePath != null && Objects.equals(this.absolutePath.path, absolutePath);
    }

    @Override
    public void clear() {
        this.content = null;
        this.absolutePath = null;
    }

    @Override
    public Stream<AreaEntry<ContentAPI>> getContentStream() {
        if (this.content != null && this.absolutePath != null) {
            return Stream.of(new AreaEntry<TContent>(this.absolutePath, this.content));
        }
        return Stream.empty();
    }

    @Override
    public Stream<AreaEntry<TContent>> getTypedContentStream() {
        if (this.content != null && this.absolutePath != null) {
            return Stream.of(new AreaEntry<TContent>(this.absolutePath, this.content));
        }
        return Stream.empty();
    }

    @Override
    public Iterator<AreaEntry<TContent>> iterator() {
        return new Iterator<AreaEntry<TContent>>(){
            private boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done && SingleContentArea.this.absolutePath != null && SingleContentArea.this.content != null;
            }

            @Override
            public AreaEntry<TContent> next() {
                this.done = true;
                return new AreaEntry<ContentAPI>(SingleContentArea.this.absolutePath, SingleContentArea.this.content);
            }
        };
    }
}

