/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.clocks;

import io.nanovc.ClockBase;
import io.nanovc.epochs.EpochWithVMNanos;
import io.nanovc.timestamps.TimestampWithVMNanos;

public abstract class AbstractClockWithVMNanos
extends ClockBase<TimestampWithVMNanos> {
    private EpochWithVMNanos lastEpoch;
    private final long minRange;
    private final long maxRange;

    public AbstractClockWithVMNanos() {
        this(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public AbstractClockWithVMNanos(long minRange, long maxRange) {
        this(null, minRange, maxRange);
    }

    public AbstractClockWithVMNanos(EpochWithVMNanos startingEpoch) {
        this(startingEpoch, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public AbstractClockWithVMNanos(EpochWithVMNanos startingEpoch, long minRange, long maxRange) {
        this.lastEpoch = startingEpoch;
        this.minRange = minRange;
        this.maxRange = maxRange;
    }

    protected abstract long nowNanos();

    protected abstract EpochWithVMNanos createNewEpoch();

    @Override
    public TimestampWithVMNanos now() {
        long deltaNanos;
        long nowNanos = this.nowNanos();
        if (this.lastEpoch == null) {
            this.lastEpoch = this.createNewEpoch();
        }
        if ((deltaNanos = nowNanos - this.lastEpoch.nanoTimeBefore) < this.minRange || deltaNanos > this.maxRange) {
            this.lastEpoch = this.createNewEpoch();
        }
        TimestampWithVMNanos timestamp = new TimestampWithVMNanos(this.lastEpoch, nowNanos);
        return timestamp;
    }
}

