/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.clocks;

import io.nanovc.clocks.AbstractClockWithVMNanos;
import io.nanovc.epochs.EpochWithVMNanos;
import java.time.Instant;

public class SimulatedClockWithVMNanos
extends AbstractClockWithVMNanos {
    private long simulatedNanos;
    private Instant simulatedInstant;
    private long simulatedEpochWindow;

    public SimulatedClockWithVMNanos(long simulatedNanos, Instant simulatedInstant, long simulatedEpochWindow) {
        this.simulatedNanos = simulatedNanos;
        this.simulatedInstant = simulatedInstant;
        this.simulatedEpochWindow = simulatedEpochWindow;
    }

    public SimulatedClockWithVMNanos(long minRange, long maxRange, long simulatedNanos, Instant simulatedInstant, long simulatedEpochWindow) {
        super(minRange, maxRange);
        this.simulatedNanos = simulatedNanos;
        this.simulatedInstant = simulatedInstant;
        this.simulatedEpochWindow = simulatedEpochWindow;
    }

    public SimulatedClockWithVMNanos(EpochWithVMNanos startingEpoch, long simulatedNanos, Instant simulatedInstant, long simulatedEpochWindow) {
        super(startingEpoch);
        this.simulatedNanos = simulatedNanos;
        this.simulatedInstant = simulatedInstant;
        this.simulatedEpochWindow = simulatedEpochWindow;
    }

    public SimulatedClockWithVMNanos(EpochWithVMNanos startingEpoch, long minRange, long maxRange, long simulatedNanos, Instant simulatedInstant, long simulatedEpochWindow) {
        super(startingEpoch, minRange, maxRange);
        this.simulatedNanos = simulatedNanos;
        this.simulatedInstant = simulatedInstant;
        this.simulatedEpochWindow = simulatedEpochWindow;
    }

    @Override
    protected long nowNanos() {
        return this.getSimulatedNanos();
    }

    @Override
    protected EpochWithVMNanos createNewEpoch() {
        long nowNanos = this.nowNanos();
        return new EpochWithVMNanos(nowNanos, this.getSimulatedInstant(), nowNanos + this.getSimulatedEpochWindow());
    }

    public long getSimulatedNanos() {
        return this.simulatedNanos;
    }

    public void setSimulatedNanos(long simulatedNanos) {
        this.simulatedNanos = simulatedNanos;
    }

    public Instant getSimulatedInstant() {
        return this.simulatedInstant;
    }

    public void setSimulatedInstant(Instant simulatedInstant) {
        this.simulatedInstant = simulatedInstant;
    }

    public long getSimulatedEpochWindow() {
        return this.simulatedEpochWindow;
    }

    public void setSimulatedEpochWindow(long simulatedEpochWindow) {
        this.simulatedEpochWindow = simulatedEpochWindow;
    }
}

