/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.comparisons;

import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEntry;
import io.nanovc.ComparisonState;
import io.nanovc.RepoPath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class HashMapComparison
extends HashMap<String, ComparisonState>
implements ComparisonAPI {
    @Override
    public void putComparison(RepoPath path, ComparisonState state) {
        this.put(((RepoPath)path.toAbsolutePath()).path, state);
    }

    @Override
    public void putComparison(String absolutePath, ComparisonState state) {
        this.put(absolutePath, state);
    }

    @Override
    public ComparisonState getComparison(RepoPath path) {
        return (ComparisonState)((Object)this.get(((RepoPath)path.toAbsolutePath()).path));
    }

    @Override
    public ComparisonState getComparison(String absolutePath) {
        return (ComparisonState)((Object)this.get(absolutePath));
    }

    @Override
    public void removeComparison(RepoPath path) {
        this.remove(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public void removeComparison(String absolutePath) {
        this.remove(absolutePath);
    }

    @Override
    public void replaceAllComparisons(Stream<ComparisonEntry> entryStream) {
        this.clear();
        entryStream.forEach((? super T entry) -> this.putComparison(entry.path, entry.state));
    }

    @Override
    public Iterator<ComparisonEntry> iterator() {
        return new Iterator<ComparisonEntry>(){
            private final Iterator<Map.Entry<String, ComparisonState>> entrySetIterator;
            {
                this.entrySetIterator = HashMapComparison.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entrySetIterator.hasNext();
            }

            @Override
            public ComparisonEntry next() {
                Map.Entry<String, ComparisonState> nextEntry = this.entrySetIterator.next();
                return new ComparisonEntry(RepoPath.at(nextEntry.getKey()), nextEntry.getValue());
            }
        };
    }

    @Override
    public boolean hasComparisons() {
        return this.size() > 0;
    }

    @Override
    public Stream<ComparisonEntry> getComparisonStream() {
        return this.entrySet().stream().map(entry -> new ComparisonEntry(RepoPath.at((String)entry.getKey()), (ComparisonState)((Object)((Object)entry.getValue()))));
    }
}

