/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.comparisons;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineBase;
import io.nanovc.ComparisonState;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import io.nanovc.comparisons.HashMapComparison;
import io.nanovc.comparisons.HashMapComparisonEngineAPI;
import java.util.Arrays;

public abstract class HashMapComparisonEngineBase
extends ComparisonEngineBase
implements HashMapComparisonEngineAPI {
    @Override
    public ComparisonAPI compare(AreaAPI<? extends ContentAPI> fromArea, AreaAPI<? extends ContentAPI> toArea) {
        HashMapComparison comparison = new HashMapComparison();
        for (AreaEntry areaEntry : fromArea) {
            byte[] toBytes;
            RepoPath path = areaEntry.path;
            ContentAPI toContent = toArea.getContent(path);
            if (toContent == null) {
                comparison.putComparison(path, ComparisonState.DELETED);
                continue;
            }
            Object fromContent = areaEntry.content;
            byte[] fromBytes = fromContent.asByteArray();
            boolean isContentEqual = Arrays.equals(fromBytes, toBytes = toContent.asByteArray());
            comparison.putComparison(path, isContentEqual ? ComparisonState.UNCHANGED : ComparisonState.CHANGED);
        }
        for (AreaEntry areaEntry : toArea) {
            String absolutePath = ((RepoPath)areaEntry.path.toAbsolutePath()).path;
            if (comparison.containsKey(absolutePath)) continue;
            comparison.putComparison(areaEntry.path, ComparisonState.ADDED);
        }
        return comparison;
    }
}

