/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.content;

import io.nanovc.ContentAPI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public interface ContentWithByteArrayAPI
extends ContentAPI {
    public byte[] getEfficientByteArray();

    @Override
    default public List<Byte> cloneContentAsByteList() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (int i = 0; i < content.length; ++i) {
            byteList.add(content[i]);
        }
        return byteList;
    }

    @Override
    default public ByteBuffer cloneContentAsByteBuffer() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(content);
    }

    @Override
    default public Stream<Byte> cloneContentAsByteStream() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return Stream.empty();
        }
        return this.cloneContentAsByteList().stream();
    }
}

