/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.content;

import io.nanovc.ContentBase;
import io.nanovc.content.ContentWithByteArrayAPI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public abstract class ContentWithByteArrayBase
extends ContentBase
implements ContentWithByteArrayAPI {
    @Override
    public byte[] asByteArray() {
        return this.getEfficientByteArray();
    }

    @Override
    public byte[] cloneContentAsByteArray() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return new byte[0];
        }
        return Arrays.copyOf(content, content.length);
    }

    @Override
    public List<Byte> cloneContentAsByteList() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (int i = 0; i < content.length; ++i) {
            byteList.add(content[i]);
        }
        return byteList;
    }

    @Override
    public ByteBuffer cloneContentAsByteBuffer() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(content);
    }

    @Override
    public Stream<Byte> cloneContentAsByteStream() {
        byte[] content = this.getEfficientByteArray();
        if (content == null || content.length == 0) {
            return Stream.empty();
        }
        return this.cloneContentAsByteList().stream();
    }
}

