/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.content;

import io.nanovc.content.ContentWithByteArrayAPI;
import io.nanovc.content.ContentWithByteArrayBase;
import io.nanovc.content.ImmutableContent;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class StringContentBase
extends ContentWithByteArrayBase
implements ContentWithByteArrayAPI,
ImmutableContent {
    public final String value;

    protected StringContentBase(String value) {
        this.value = value;
    }

    protected StringContentBase(byte[] bytes, Charset charset) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(charset);
        this.value = new String(bytes, charset);
    }

    public abstract Charset getCharset();

    public String getValue() {
        return this.value;
    }

    @Override
    public byte[] getEfficientByteArray() {
        if (this.value == null) {
            return new byte[0];
        }
        return this.value.getBytes(this.getCharset());
    }

    @Override
    public String toString() {
        return '\'' + this.value + '\'';
    }
}

