/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.differences;

import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEntry;
import io.nanovc.DifferenceState;
import io.nanovc.RepoPath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class HashMapDifference
extends HashMap<String, DifferenceState>
implements DifferenceAPI {
    @Override
    public void putDifference(RepoPath path, DifferenceState state) {
        this.put(((RepoPath)path.toAbsolutePath()).path, state);
    }

    @Override
    public void putDifference(String absolutePath, DifferenceState state) {
        this.put(absolutePath, state);
    }

    @Override
    public DifferenceState getDifference(RepoPath path) {
        return (DifferenceState)((Object)this.get(((RepoPath)path.toAbsolutePath()).path));
    }

    @Override
    public DifferenceState getDifference(String absolutePath) {
        return (DifferenceState)((Object)this.get(absolutePath));
    }

    @Override
    public void removeDifference(RepoPath path) {
        this.remove(((RepoPath)path.toAbsolutePath()).path);
    }

    @Override
    public void removeDifference(String absolutePath) {
        this.remove(absolutePath);
    }

    @Override
    public void replaceAllDifferences(Stream<DifferenceEntry> entryStream) {
        this.clear();
        entryStream.forEach((? super T entry) -> this.putDifference(entry.path, entry.state));
    }

    @Override
    public Iterator<DifferenceEntry> iterator() {
        return new Iterator<DifferenceEntry>(){
            private final Iterator<Map.Entry<String, DifferenceState>> entrySetIterator;
            {
                this.entrySetIterator = HashMapDifference.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entrySetIterator.hasNext();
            }

            @Override
            public DifferenceEntry next() {
                Map.Entry<String, DifferenceState> nextEntry = this.entrySetIterator.next();
                return new DifferenceEntry(RepoPath.at(nextEntry.getKey()), nextEntry.getValue());
            }
        };
    }

    @Override
    public boolean hasDifferences() {
        return this.size() > 0;
    }

    @Override
    public Stream<DifferenceEntry> getDifferenceStream() {
        return this.entrySet().stream().map(entry -> new DifferenceEntry(RepoPath.at((String)entry.getKey()), (DifferenceState)((Object)((Object)entry.getValue()))));
    }
}

