/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.differences;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineBase;
import io.nanovc.DifferenceState;
import io.nanovc.RepoPath;
import io.nanovc.differences.HashMapDifference;
import io.nanovc.differences.HashMapDifferenceEngineAPI;
import java.util.Arrays;

public abstract class HashMapDifferenceEngineBase
extends DifferenceEngineBase
implements HashMapDifferenceEngineAPI {
    @Override
    public DifferenceAPI computeDifference(AreaAPI<? extends ContentAPI> fromArea, AreaAPI<? extends ContentAPI> toArea) {
        RepoPath path;
        HashMapDifference difference = new HashMapDifference();
        for (AreaEntry areaEntry : fromArea) {
            byte[] toBytes;
            path = areaEntry.path;
            ContentAPI toContent = toArea.getContent(path);
            if (toContent == null) {
                difference.putDifference(path, DifferenceState.DELETED);
                continue;
            }
            Object fromContent = areaEntry.content;
            byte[] fromBytes = fromContent.asByteArray();
            boolean isContentEqual = Arrays.equals(fromBytes, toBytes = toContent.asByteArray());
            if (isContentEqual) continue;
            difference.putDifference(path, DifferenceState.CHANGED);
        }
        for (AreaEntry areaEntry : toArea) {
            path = areaEntry.path;
            String absolutePath = ((RepoPath)path.toAbsolutePath()).path;
            if (difference.containsKey(absolutePath) || fromArea.hasContent(path)) continue;
            difference.putDifference(areaEntry.path, DifferenceState.ADDED);
        }
        return difference;
    }
}

