/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.epochs;

import io.nanovc.EpochBase;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class EpochWithNanoWindow
extends EpochBase {
    public final Instant globalTime;
    public final int nanoUncertaintyWindow;

    public EpochWithNanoWindow(Instant globalTime, int nanoUncertaintyWindow) {
        this.globalTime = globalTime;
        this.nanoUncertaintyWindow = nanoUncertaintyWindow;
    }

    public EpochWithNanoWindow(int nanoUncertaintyWindow) {
        this.globalTime = Instant.now();
        this.nanoUncertaintyWindow = nanoUncertaintyWindow;
    }

    public EpochWithNanoWindow(Clock globalClock, int nanoUncertaintyWindow) {
        this.globalTime = Instant.now(globalClock);
        this.nanoUncertaintyWindow = nanoUncertaintyWindow;
    }

    @Override
    public Duration getUncertaintyDuration() {
        return Duration.ofNanos(this.nanoUncertaintyWindow);
    }

    @Override
    public Instant getGlobalTime() {
        return this.globalTime;
    }
}

