/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.epochs;

import io.nanovc.EpochBase;
import io.nanovc.epochs.EpochWithNanoWindow;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class EpochWithVMNanos
extends EpochBase {
    public final long nanoTimeBefore;
    public final Instant globalTime;
    public final long nanoTimeAfter;

    public EpochWithVMNanos(long nanoTimeBefore, Instant globalTime, long nanoTimeAfter) {
        this.nanoTimeBefore = nanoTimeBefore;
        this.globalTime = globalTime;
        this.nanoTimeAfter = nanoTimeAfter;
    }

    public EpochWithVMNanos() {
        this.nanoTimeBefore = System.nanoTime();
        this.globalTime = Instant.now();
        this.nanoTimeAfter = System.nanoTime();
    }

    public EpochWithVMNanos(Clock globalClock) {
        this.nanoTimeBefore = System.nanoTime();
        this.globalTime = Instant.now(globalClock);
        this.nanoTimeAfter = System.nanoTime();
    }

    public int getNanoTimeDurationInt() {
        return (int)(this.nanoTimeAfter - this.nanoTimeBefore);
    }

    public long getNanoTimeDurationLong() {
        return this.nanoTimeAfter - this.nanoTimeBefore;
    }

    public EpochWithNanoWindow toEpochWithNanoWindow() {
        return new EpochWithNanoWindow(this.globalTime, this.getNanoTimeDurationInt());
    }

    @Override
    public Instant getGlobalTime() {
        return this.globalTime;
    }

    @Override
    public Duration getUncertaintyDuration() {
        return Duration.ofNanos(this.getNanoTimeDurationLong());
    }
}

