/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.indexes;

import io.nanovc.ByteArrayIndex;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class HashWrapperByteArrayIndex
implements ByteArrayIndex {
    protected final HashMap<ByteArrayWrapper, byte[]> index = new HashMap();

    @Override
    public byte[] addOrLookup(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayWrapper wrapper = new ByteArrayWrapper(bytes);
        byte[] result = this.index.computeIfAbsent(wrapper, byteArrayWrapper -> byteArrayWrapper.bytes);
        return result;
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    public static class ByteArrayWrapper {
        public final byte[] bytes;
        public final int hash;

        public ByteArrayWrapper(byte[] bytes) {
            Objects.requireNonNull(bytes);
            this.bytes = bytes;
            this.hash = Arrays.hashCode(bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayWrapper)) {
                return false;
            }
            ByteArrayWrapper that = (ByteArrayWrapper)o;
            return this.hash == that.hash && Arrays.equals(this.bytes, that.bytes);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

