/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.indexes;

import io.nanovc.ByteArrayIndex;
import io.nanovc.indexes.Bits;
import java.util.HashMap;

public class ValueTreeByteArrayIndex
implements ByteArrayIndex {
    protected byte[] zeroByteArray;
    protected final ValueNode rootNode = new ValueNode();

    @Override
    public byte[] addOrLookup(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            if (this.zeroByteArray == null) {
                this.zeroByteArray = bytes;
            }
            return this.zeroByteArray;
        }
        ValueNode currentNode = this.rootNode;
        int remainingBytes = bytes.length;
        int arrayIndex = 0;
        while (remainingBytes > 0) {
            ValueNode nextNode;
            int stepSize;
            int nextValue = Bits.byteArrayToInt(bytes, arrayIndex, remainingBytes);
            switch (remainingBytes) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    arrayIndex += remainingBytes;
                    stepSize = remainingBytes;
                    remainingBytes = 0;
                    break;
                }
                default: {
                    arrayIndex += 4;
                    remainingBytes -= 4;
                    stepSize = 4;
                }
            }
            switch (stepSize) {
                case 1: {
                    if (currentNode.size1ValueNode == null) {
                        currentNode.size1ValueNode = nextNode = new ValueNode();
                        currentNode.size1Value = nextValue;
                        break;
                    }
                    if (currentNode.size1Value == nextValue) {
                        nextNode = currentNode.size1ValueNode;
                        break;
                    }
                    if (currentNode.size1ValueNodes == null) {
                        currentNode.size1ValueNodes = new HashMap();
                    }
                    nextNode = currentNode.size1ValueNodes.computeIfAbsent(nextValue, integer -> new ValueNode());
                    break;
                }
                case 2: {
                    if (currentNode.size2ValueNode == null) {
                        currentNode.size2ValueNode = nextNode = new ValueNode();
                        currentNode.size2Value = nextValue;
                        break;
                    }
                    if (currentNode.size2Value == nextValue) {
                        nextNode = currentNode.size2ValueNode;
                        break;
                    }
                    if (currentNode.size2ValueNodes == null) {
                        currentNode.size2ValueNodes = new HashMap();
                    }
                    nextNode = currentNode.size2ValueNodes.computeIfAbsent(nextValue, integer -> new ValueNode());
                    break;
                }
                case 3: {
                    if (currentNode.size3ValueNode == null) {
                        currentNode.size3ValueNode = nextNode = new ValueNode();
                        currentNode.size3Value = nextValue;
                        break;
                    }
                    if (currentNode.size3Value == nextValue) {
                        nextNode = currentNode.size3ValueNode;
                        break;
                    }
                    if (currentNode.size3ValueNodes == null) {
                        currentNode.size3ValueNodes = new HashMap();
                    }
                    nextNode = currentNode.size3ValueNodes.computeIfAbsent(nextValue, integer -> new ValueNode());
                    break;
                }
                case 4: {
                    if (currentNode.size4ValueNode == null) {
                        currentNode.size4ValueNode = nextNode = new ValueNode();
                        currentNode.size4Value = nextValue;
                        break;
                    }
                    if (currentNode.size4Value == nextValue) {
                        nextNode = currentNode.size4ValueNode;
                        break;
                    }
                    if (currentNode.size4ValueNodes == null) {
                        currentNode.size4ValueNodes = new HashMap();
                    }
                    nextNode = currentNode.size4ValueNodes.computeIfAbsent(nextValue, integer -> new ValueNode());
                    break;
                }
                default: {
                    nextNode = null;
                }
            }
            currentNode = nextNode;
        }
        if (currentNode.array == null) {
            currentNode.array = bytes;
            return bytes;
        }
        return currentNode.array;
    }

    @Override
    public void clear() {
        this.zeroByteArray = null;
        this.rootNode.array = null;
        this.rootNode.size1Value = 0;
        this.rootNode.size2Value = 0;
        this.rootNode.size3Value = 0;
        this.rootNode.size4Value = 0;
        this.rootNode.size1ValueNode = null;
        this.rootNode.size2ValueNode = null;
        this.rootNode.size3ValueNode = null;
        this.rootNode.size4ValueNode = null;
        this.rootNode.size1ValueNodes = null;
        this.rootNode.size2ValueNodes = null;
        this.rootNode.size3ValueNodes = null;
        this.rootNode.size4ValueNodes = null;
    }

    private static class ValueNode {
        public int size1Value;
        public ValueNode size1ValueNode;
        public HashMap<Integer, ValueNode> size1ValueNodes;
        public int size2Value;
        public ValueNode size2ValueNode;
        public HashMap<Integer, ValueNode> size2ValueNodes;
        public int size3Value;
        public ValueNode size3ValueNode;
        public HashMap<Integer, ValueNode> size3ValueNodes;
        public int size4Value;
        public ValueNode size4ValueNode;
        public HashMap<Integer, ValueNode> size4ValueNodes;
        public byte[] array;

        private ValueNode() {
        }
    }

    private static class HashNode {
        public ValueNode valueNode = new ValueNode();

        private HashNode() {
        }
    }
}

