/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.merges;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.ByteArrayIndex;
import io.nanovc.CommitAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEntry;
import io.nanovc.MergeEngineBase;
import io.nanovc.RepoPath;
import io.nanovc.merges.DiffFromCommonAncestorMergeEngineAPI;

public abstract class DiffFromCommonAncestorMergeEngineBase
extends MergeEngineBase
implements DiffFromCommonAncestorMergeEngineAPI {
    @Override
    public <TContent extends ContentAPI> void mergeIntoAreaWithThreeWayDiff(AreaAPI<TContent> mergedAreaToUpdate, CommitAPI commonAncestorCommit, CommitAPI sourceCommit, CommitAPI destinationCommit, AreaAPI<TContent> commonAncestorArea, AreaAPI<TContent> sourceArea, AreaAPI<TContent> destinationArea, ComparisonAPI comparisonBetweenSourceAndDestination, DifferenceAPI differenceBetweenAncestorAndSource, DifferenceAPI differenceBetweenAncestorAndDestination, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        this.mergeArea(destinationArea, mergedAreaToUpdate, contentFactory, byteArrayIndex);
        for (DifferenceEntry differenceEntry : differenceBetweenAncestorAndSource) {
            RepoPath path = differenceEntry.path;
            switch (differenceEntry.state) {
                case ADDED: 
                case CHANGED: {
                    byte[] bytes = sourceArea.getContent(path).asByteArray();
                    bytes = byteArrayIndex.addOrLookup(bytes);
                    TContent outputContent = contentFactory.createContent(bytes);
                    mergedAreaToUpdate.putContent(path, outputContent);
                    break;
                }
                case DELETED: {
                    mergedAreaToUpdate.removeContent(path);
                }
            }
        }
    }

    @Override
    public <TContent extends ContentAPI> void mergeIntoAreaWithTwoWayDiff(AreaAPI<TContent> mergedAreaToUpdate, CommitAPI sourceCommit, CommitAPI destinationCommit, AreaAPI<TContent> sourceArea, AreaAPI<TContent> destinationArea, ComparisonAPI comparisonBetweenSourceAndDestination, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        this.mergeArea(destinationArea, mergedAreaToUpdate, contentFactory, byteArrayIndex);
        this.mergeArea(sourceArea, mergedAreaToUpdate, contentFactory, byteArrayIndex);
    }

    protected <TContent extends ContentAPI> void mergeArea(AreaAPI<TContent> areaToMerge, AreaAPI<TContent> mergedAreaToUpdate, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        for (AreaEntry areaEntry : areaToMerge) {
            RepoPath path = areaEntry.getPath();
            byte[] bytes = areaEntry.getContent().asByteArray();
            bytes = byteArrayIndex.addOrLookup(bytes);
            TContent outputContent = contentFactory.createContent(bytes);
            mergedAreaToUpdate.putContent(path, outputContent);
        }
    }
}

