/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.merges;

import io.nanovc.AreaAPI;
import io.nanovc.ByteArrayIndex;
import io.nanovc.CommitAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEntry;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceState;
import io.nanovc.MergeEngineBase;
import io.nanovc.RepoPath;
import io.nanovc.merges.DiffingMergeEngineAPI;

public abstract class DiffingMergeEngineBase
extends MergeEngineBase
implements DiffingMergeEngineAPI {
    @Override
    public <TContent extends ContentAPI> void mergeIntoAreaWithThreeWayDiff(AreaAPI<TContent> mergedAreaToUpdate, CommitAPI commonAncestorCommit, CommitAPI sourceCommit, CommitAPI destinationCommit, AreaAPI<TContent> commonAncestorArea, AreaAPI<TContent> sourceArea, AreaAPI<TContent> destinationArea, ComparisonAPI comparisonBetweenSourceAndDestination, DifferenceAPI differenceBetweenAncestorAndSource, DifferenceAPI differenceBetweenAncestorAndDestination, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        for (ComparisonEntry comparisonEntry : comparisonBetweenSourceAndDestination) {
            byte[] bytes;
            RepoPath path = comparisonEntry.path;
            block0 : switch (comparisonEntry.state) {
                case ADDED: 
                case UNCHANGED: {
                    TContent sourceContent = sourceArea.getContent(path);
                    bytes = sourceContent.asByteArray();
                    break;
                }
                case CHANGED: {
                    TContent destinationContent;
                    DifferenceState sourceDifference = differenceBetweenAncestorAndSource.getDifference(path);
                    DifferenceState destinationDifference = differenceBetweenAncestorAndDestination.getDifference(path);
                    if (sourceDifference == null) {
                        if (destinationDifference == null) {
                            bytes = null;
                            break;
                        }
                        switch (destinationDifference) {
                            case ADDED: 
                            case CHANGED: {
                                destinationContent = destinationArea.getContent(path);
                                bytes = destinationContent.asByteArray();
                                break block0;
                            }
                        }
                        bytes = null;
                        break;
                    }
                    switch (sourceDifference) {
                        case ADDED: 
                        case CHANGED: {
                            TContent sourceContent;
                            if (destinationDifference == null) {
                                sourceContent = sourceArea.getContent(path);
                                bytes = sourceContent.asByteArray();
                                break block0;
                            }
                            switch (destinationDifference) {
                                case ADDED: 
                                case CHANGED: {
                                    sourceContent = sourceArea.getContent(path);
                                    TContent destinationContent2 = destinationArea.getContent(path);
                                    bytes = this.resolveConflictForChangesInSourceAndDestinationBranches(path, sourceCommit, sourceContent, sourceDifference, destinationCommit, destinationContent2, destinationDifference);
                                    break block0;
                                }
                                case DELETED: {
                                    sourceContent = sourceArea.getContent(path);
                                    bytes = this.resolveConflictForChangesInSourceBranchButDeletionInDestinationBranch(path, sourceCommit, sourceContent, sourceDifference, destinationCommit, destinationDifference);
                                    break block0;
                                }
                            }
                            bytes = null;
                            break block0;
                        }
                        case DELETED: {
                            if (destinationDifference == null) {
                                bytes = null;
                                break block0;
                            }
                            switch (destinationDifference) {
                                case ADDED: 
                                case CHANGED: {
                                    destinationContent = destinationArea.getContent(path);
                                    bytes = this.resolveConflictForDeletionInSourceBranchButChangeInDestinationBranch(path, sourceCommit, sourceDifference, destinationCommit, destinationContent, destinationDifference);
                                    break block0;
                                }
                            }
                            bytes = null;
                            break block0;
                        }
                    }
                    bytes = null;
                    break;
                }
                default: {
                    bytes = null;
                }
            }
            if (bytes == null) continue;
            bytes = byteArrayIndex.addOrLookup(bytes);
            TContent mergedContent = contentFactory.createContent(bytes);
            mergedAreaToUpdate.putContent(path, mergedContent);
        }
    }

    protected abstract <TContent extends ContentAPI> byte[] resolveConflictForChangesInSourceAndDestinationBranches(RepoPath var1, CommitAPI var2, TContent var3, DifferenceState var4, CommitAPI var5, TContent var6, DifferenceState var7);

    protected abstract <TContent extends ContentAPI> byte[] resolveConflictForChangesInSourceBranchButDeletionInDestinationBranch(RepoPath var1, CommitAPI var2, TContent var3, DifferenceState var4, CommitAPI var5, DifferenceState var6);

    protected abstract <TContent extends ContentAPI> byte[] resolveConflictForDeletionInSourceBranchButChangeInDestinationBranch(RepoPath var1, CommitAPI var2, DifferenceState var3, CommitAPI var4, TContent var5, DifferenceState var6);

    @Override
    public <TContent extends ContentAPI> void mergeIntoAreaWithTwoWayDiff(AreaAPI<TContent> mergedAreaToUpdate, CommitAPI sourceCommit, CommitAPI destinationCommit, AreaAPI<TContent> sourceArea, AreaAPI<TContent> destinationArea, ComparisonAPI comparisonBetweenSourceAndDestination, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        for (ComparisonEntry comparisonEntry : comparisonBetweenSourceAndDestination) {
            byte[] bytes;
            RepoPath path = comparisonEntry.path;
            switch (comparisonEntry.state) {
                case ADDED: {
                    TContent sourceContent = sourceArea.getContent(path);
                    bytes = sourceContent.asByteArray();
                    break;
                }
                case UNCHANGED: 
                case DELETED: {
                    TContent destinationContent = destinationArea.getContent(path);
                    bytes = destinationContent.asByteArray();
                    break;
                }
                case CHANGED: {
                    TContent sourceContent = sourceArea.getContent(path);
                    TContent destinationContent = destinationArea.getContent(path);
                    bytes = this.resolveConflictForTwoWayMerge(path, sourceCommit, sourceContent, destinationCommit, destinationContent);
                    break;
                }
                default: {
                    bytes = null;
                }
            }
            if (bytes == null) continue;
            bytes = byteArrayIndex.addOrLookup(bytes);
            TContent mergedContent = contentFactory.createContent(bytes);
            mergedAreaToUpdate.putContent(path, mergedContent);
        }
    }

    protected abstract <TContent extends ContentAPI> byte[] resolveConflictForTwoWayMerge(RepoPath var1, CommitAPI var2, TContent var3, CommitAPI var4, TContent var5);
}

