/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.merges;

import io.nanovc.CommitAPI;
import io.nanovc.ContentAPI;
import io.nanovc.DifferenceState;
import io.nanovc.RepoPath;
import io.nanovc.merges.DiffingMergeEngineBase;
import io.nanovc.merges.LastWinsMergeEngineAPI;

public abstract class LastWinsMergeEngineBase
extends DiffingMergeEngineBase
implements LastWinsMergeEngineAPI {
    @Override
    protected <TContent extends ContentAPI> byte[] resolveConflictForChangesInSourceAndDestinationBranches(RepoPath path, CommitAPI sourceCommit, TContent sourceContent, DifferenceState sourceDifference, CommitAPI destinationCommit, TContent destinationContent, DifferenceState destinationDifference) {
        if (sourceCommit.getTimestamp().getInstant().isAfter(destinationCommit.getTimestamp().getInstant())) {
            return sourceContent.asByteArray();
        }
        return destinationContent.asByteArray();
    }

    @Override
    protected <TContent extends ContentAPI> byte[] resolveConflictForChangesInSourceBranchButDeletionInDestinationBranch(RepoPath path, CommitAPI sourceCommit, TContent sourceContent, DifferenceState sourceDifference, CommitAPI destinationCommit, DifferenceState destinationDifference) {
        if (sourceCommit.getTimestamp().getInstant().isAfter(destinationCommit.getTimestamp().getInstant())) {
            return sourceContent.asByteArray();
        }
        return null;
    }

    @Override
    protected <TContent extends ContentAPI> byte[] resolveConflictForDeletionInSourceBranchButChangeInDestinationBranch(RepoPath path, CommitAPI sourceCommit, DifferenceState sourceDifference, CommitAPI destinationCommit, TContent destinationContent, DifferenceState destinationDifference) {
        if (sourceCommit.getTimestamp().getInstant().isAfter(destinationCommit.getTimestamp().getInstant())) {
            return null;
        }
        return destinationContent.asByteArray();
    }

    @Override
    protected <TContent extends ContentAPI> byte[] resolveConflictForTwoWayMerge(RepoPath path, CommitAPI sourceCommit, TContent sourceContent, CommitAPI destinationCommit, TContent destinationContent) {
        if (sourceCommit.getTimestamp().getInstant().isAfter(destinationCommit.getTimestamp().getInstant())) {
            return sourceContent.asByteArray();
        }
        return destinationContent.asByteArray();
    }
}

