/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.reflection;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class ClassType {
    private final Class<?> classType;
    private final ClassType[] parameterTypes;

    public ClassType(Class<?> classType) {
        this.classType = classType;
        this.parameterTypes = null;
    }

    public ClassType(Class<?> classType, ClassType ... parameterTypes) {
        this.classType = classType;
        this.parameterTypes = parameterTypes;
    }

    public static <T> ClassType of(Class<T> classType) {
        return new ClassType(classType);
    }

    public static <T, P1> ClassType of(Class<T> classType, Class<P1> parameter1Class) {
        return new ClassType(classType, ClassType.of(parameter1Class));
    }

    public static <T, P1, P2> ClassType of(Class<T> classType, Class<P1> parameter1Class, Class<P2> parameter2Class) {
        return new ClassType(classType, ClassType.of(parameter1Class), ClassType.of(parameter2Class));
    }

    public String toString() {
        if (this.classType == null) {
            return super.toString();
        }
        if (this.parameterTypes != null && this.parameterTypes.length > 0) {
            StringJoiner stringJoiner = new StringJoiner(",", this.classType.getSimpleName() + "<", ">");
            for (ClassType parameterType : this.parameterTypes) {
                stringJoiner.add(parameterType.toString());
            }
            return stringJoiner.toString();
        }
        return this.classType.getSimpleName();
    }

    public Object newInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public ClassType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassType)) {
            return false;
        }
        ClassType classType1 = (ClassType)o;
        return Objects.equals(this.getClassType(), classType1.getClassType()) && Arrays.equals(this.getParameterTypes(), classType1.getParameterTypes());
    }

    public int hashCode() {
        int result = Objects.hash(this.getClassType());
        result = 31 * result + Arrays.hashCode(this.getParameterTypes());
        return result;
    }
}

