/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.searches.commits.expressions;

import io.nanovc.reflection.ClassType;
import io.nanovc.searches.commits.expressions.Expression;

public class ConstantExpression<T>
extends Expression<T> {
    private final T value;

    public ConstantExpression(ClassType valueType, T value) {
        super(valueType);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public static <T> ConstantExpression<T> of(ClassType valueType, T value) {
        return new ConstantExpression<T>(valueType, value);
    }

    public static <T> ConstantExpression<T> of(Class<T> valueType, T value) {
        return new ConstantExpression<T>(ClassType.of(valueType), value);
    }

    @Override
    public String toString() {
        if (this.value == null || this.getReturnType() == null) {
            return super.toString();
        }
        return this.value.toString() + ":" + this.getReturnType().toString();
    }
}

