/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.searches.commits.expressions;

import io.nanovc.reflection.ClassType;
import io.nanovc.searches.commits.expressions.ConstantExpression;
import io.nanovc.searches.commits.expressions.EqualExpression;
import io.nanovc.searches.commits.expressions.NotEqualExpression;

public abstract class Expression<T> {
    private final ClassType returnType;

    public Expression(ClassType returnType) {
        this.returnType = returnType;
    }

    public ClassType getReturnType() {
        return this.returnType;
    }

    public EqualExpression<T> Equals(Expression<T> rightExpression) {
        return new EqualExpression<T>(this.returnType, this, rightExpression);
    }

    public EqualExpression<T> EqualsConstant(T value) {
        return new EqualExpression<T>(this.returnType, this, ConstantExpression.of(this.returnType, value));
    }

    public NotEqualExpression<T> NotEquals(Expression<T> rightExpression) {
        return new NotEqualExpression<T>(this.returnType, this, rightExpression);
    }

    public NotEqualExpression<T> NotEqualsConstant(T value) {
        return new NotEqualExpression<T>(this.returnType, this, ConstantExpression.of(this.returnType, value));
    }

    public String toString() {
        if (this.returnType == null) {
            return super.toString();
        }
        return "?:" + this.returnType.toString();
    }
}

