/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.AreaAPI;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.memory.MemoryCommit;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemoryRepo;
import io.nanovc.memory.MemoryRepoEngine;
import io.nanovc.memory.MemoryRepoHandlerAPI;
import io.nanovc.memory.MemorySearchQuery;
import io.nanovc.memory.MemorySearchResults;
import io.nanovc.merges.DiffFromCommonAncestorMergeHandler;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class MemoryNanoRepo
extends MemoryRepo<ByteArrayContent, ByteArrayHashMapArea>
implements MemoryRepoHandlerAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, MemoryRepo<ByteArrayContent, ByteArrayHashMapArea>, MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea>> {
    public static final ClockAPI<? extends TimestampAPI> COMMON_CLOCK = ClockWithVMNanos.COMMON_CLOCK;
    protected ClockAPI<? extends TimestampAPI> clock = COMMON_CLOCK;
    public static final MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> COMMON_ENGINE = new MemoryRepoEngine();
    protected MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine = COMMON_ENGINE;
    public static final HashMapDifferenceHandler COMMON_DIFFERENCE_HANDLER = HashMapDifferenceHandler.COMMON_DIFFERENCE_HANDLER;
    protected DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler = COMMON_DIFFERENCE_HANDLER;
    public static final HashMapComparisonHandler COMMON_COMPARISON_HANDLER = HashMapComparisonHandler.COMMON_COMPARISON_HANDLER;
    protected ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler = COMMON_COMPARISON_HANDLER;
    public static final MergeHandlerAPI<? extends MergeEngineAPI> COMMON_MERGE_HANDLER = DiffFromCommonAncestorMergeHandler.COMMON_MERGE_HANDLER;
    protected MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler = COMMON_MERGE_HANDLER;
    protected ByteArrayIndex byteArrayIndex;

    public MemoryNanoRepo() {
        this.ensureDependenciesExist();
    }

    public MemoryNanoRepo(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
        this.ensureDependenciesExist();
    }

    public MemoryNanoRepo(ByteArrayIndex byteArrayIndex, MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine, ClockAPI<? extends TimestampAPI> clock, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.byteArrayIndex = byteArrayIndex;
        this.engine = engine;
        this.clock = clock;
        this.differenceHandler = differenceHandler;
        this.comparisonHandler = comparisonHandler;
        this.mergeHandler = mergeHandler;
        this.ensureDependenciesExist();
    }

    private void ensureDependenciesExist() {
        if (this.engine == null) {
            this.engine = COMMON_ENGINE;
        }
        if (this.byteArrayIndex == null) {
            this.byteArrayIndex = this.engine.createByteArrayIndex();
        }
        if (this.clock == null) {
            this.clock = this.engine.createClock();
        }
        if (this.differenceHandler == null) {
            this.differenceHandler = new HashMapDifferenceHandler();
        }
        if (this.comparisonHandler == null) {
            this.comparisonHandler = new HashMapComparisonHandler();
        }
        if (this.mergeHandler == null) {
            this.mergeHandler = new LastWinsMergeHandler();
        }
    }

    public ByteArrayHashMapArea createArea() {
        return (ByteArrayHashMapArea)this.engine.createArea(ByteArrayHashMapArea::new);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit parentCommit) {
        return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, parentCommit);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, List<MemoryCommit> parentCommits) {
        if (parentCommits == null) {
            return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
        }
        switch (parentCommits.size()) {
            case 0: {
                return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
            }
            case 1: {
                return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0));
            }
        }
        return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0), parentCommits.subList(1, parentCommits.size()));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, firstParentCommit, otherParentCommits);
    }

    public MemoryCommit commitToBranch(ByteArrayHashMapArea contentAreaToCommit, String branch, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.engine.commitToBranch(contentAreaToCommit, branch, message, commitTags, this, this.byteArrayIndex, this.clock);
    }

    public void createBranchAtCommit(MemoryCommit commit, String branchName) {
        this.engine.createBranchAtCommit(commit, branchName, this);
    }

    public void removeBranch(String branchName) {
        this.engine.removeBranch(this, branchName);
    }

    public MemoryCommit getLatestCommitForBranch(String branchName) {
        return (MemoryCommit)this.engine.getLatestCommitForBranch(branchName, this);
    }

    public void checkoutIntoArea(MemoryCommit commit, ByteArrayHashMapArea areaToUpdate) {
        this.engine.checkoutIntoArea(commit, this, areaToUpdate, ByteArrayContent::new);
    }

    public ByteArrayHashMapArea checkout(MemoryCommit commit) {
        return (ByteArrayHashMapArea)this.engine.checkout(commit, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public void tagCommit(MemoryCommit commit, String tagName) {
        this.engine.tagCommit(this, commit, tagName);
    }

    public MemoryCommit getCommitForTag(String tagName) {
        return (MemoryCommit)this.engine.getCommitForTag(this, tagName);
    }

    public void removeTag(String tagName) {
        this.engine.removeTag(this, tagName);
    }

    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.engine.computeDifferenceBetweenAreas(fromArea, toArea, this.differenceHandler);
    }

    public DifferenceAPI computeDifferenceBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.engine.computeDifferenceBetweenCommits(fromCommit, toCommit, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public DifferenceAPI computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return this.engine.computeDifferenceBetweenBranches(fromBranchName, toBranchName, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.engine.computeComparisonBetweenAreas(fromArea, toArea, this.comparisonHandler);
    }

    public ComparisonAPI computeComparisonBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.engine.computeComparisonBetweenCommits(fromCommit, toCommit, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public ComparisonAPI computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return this.engine.computeComparisonBetweenBranches(fromBranchName, toBranchName, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Set<String> getBranchNames() {
        return this.engine.getBranchNames(this);
    }

    public Set<String> getTagNames() {
        return this.engine.getTagNames(this);
    }

    public MemoryRepo<ByteArrayContent, ByteArrayHashMapArea> getRepo() {
        return this;
    }

    public void setRepo(MemoryRepo<ByteArrayContent, ByteArrayHashMapArea> repo) {
        throw new IllegalArgumentException("Cannot set a memory nano repo to another memory nano repo. That doesn't make sense for Object Oriented nano repos.");
    }

    public MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> getEngine() {
        return this.engine;
    }

    public void setEngine(MemoryRepoEngine<ByteArrayContent, ByteArrayHashMapArea> engine) {
        this.engine = engine;
    }

    public ClockAPI<? extends TimestampAPI> getClock() {
        return this.clock;
    }

    public void setClock(ClockAPI<? extends TimestampAPI> clock) {
        this.clock = clock;
    }

    public DifferenceHandlerAPI<? extends DifferenceEngineAPI> getDifferenceHandler() {
        return this.differenceHandler;
    }

    public void setDifferenceHandler(DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler) {
        this.differenceHandler = differenceHandler;
    }

    public ComparisonHandlerAPI<? extends ComparisonEngineAPI> getComparisonHandler() {
        return this.comparisonHandler;
    }

    public void setComparisonHandler(ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler) {
        this.comparisonHandler = comparisonHandler;
    }

    public MergeHandlerAPI<? extends MergeEngineAPI> getMergeHandler() {
        return this.mergeHandler;
    }

    public void setMergeHandler(MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.mergeHandler = mergeHandler;
    }

    public MemorySearchQuery prepareSearchQuery(SearchQueryDefinitionAPI searchQueryDefinition) {
        return (MemorySearchQuery)this.engine.prepareSearchQuery(searchQueryDefinition);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery) {
        return (MemorySearchResults)this.engine.searchWithQuery(searchQuery, null, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery, SearchParametersAPI overrideParameters) {
        return (MemorySearchResults)this.engine.searchWithQuery(searchQuery, overrideParameters, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery);
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition, SearchParametersAPI overrideParameters) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery, overrideParameters);
    }

    public MemoryCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.engine.mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, commitTags, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock);
    }

    public MemoryCommit mergeIntoBranchFromCommit(String destinationBranchName, MemoryCommit sourceCommit, String message, StringAreaAPI commitTags) {
        return this.getEngine().mergeIntoBranchFromCommit(destinationBranchName, sourceCommit, message, commitTags, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock);
    }

    public MemoryCommit mergeIntoCommitFromBranch(MemoryCommit destinationCommit, String sourceBranchName, String message, StringAreaAPI commitTags) {
        return this.getEngine().mergeIntoCommitFromBranch(destinationCommit, sourceBranchName, message, commitTags, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock);
    }

    public MemoryCommit mergeCommits(MemoryCommit destinationCommit, MemoryCommit sourceCommit, String message, StringAreaAPI commitTags) {
        return this.getEngine().mergeCommits(destinationCommit, sourceCommit, message, commitTags, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock);
    }

    public ByteArrayHashMapArea castOrCloneArea(AreaAPI<? extends ContentAPI> areaToCastOrClone) {
        return (ByteArrayHashMapArea)this.engine.castOrCloneArea(areaToCastOrClone, this::createArea, ByteArrayContent::new, this.byteArrayIndex);
    }
}

