/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.logging.I18NLogger;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public final class HibernateSetup {
    public static final String DB_TABLE_NAME_PARAM = "db.table.name";
    public static final String HIBERNATE_DIALECT_PARAM = "hibernate.dialect";
    public static final String HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM = "hibernate.connection.driver_class";
    public static final String HIBERNATE_CONNECTION_URL_PARAM = "hibernate.connection.url";
    public static final String HIBERNATE_CONNECTION_USERNAME_PARAM = "hibernate.connection.username";
    public static final String HIBERNATE_CONNECTION_PASSWORD_PARAM = "hibernate.connection.password";

    private HibernateSetup() {
    }

    public static Properties getConfigurationProperties(ParsedArguments args) {
        Properties outputProperties = HibernateSetup.getConfigurationProperties();
        HibernateSetup.setIfNotNull(HIBERNATE_DIALECT_PARAM, args.getHibernateDialect(), outputProperties);
        HibernateSetup.setIfNotNull(HIBERNATE_DIALECT_PARAM, args.getHibernateDialect(), outputProperties);
        HibernateSetup.setIfNotNull(HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM, args.getJdbcDriverClass(), outputProperties);
        HibernateSetup.setIfNotNull(HIBERNATE_CONNECTION_URL_PARAM, args.getJdbcUrl(), outputProperties);
        HibernateSetup.setIfNotNull(HIBERNATE_CONNECTION_USERNAME_PARAM, args.getUser(), outputProperties);
        HibernateSetup.setIfNotNull(HIBERNATE_CONNECTION_PASSWORD_PARAM, args.getPassword(), outputProperties);
        HibernateSetup.setIfNotNull(DB_TABLE_NAME_PARAM, args.getTableName(), outputProperties);
        return outputProperties;
    }

    public static Properties getConfigurationProperties() {
        Properties outputProperties = new Properties();
        HibernateSetup.getAndWriteProperty(HIBERNATE_DIALECT_PARAM, outputProperties);
        HibernateSetup.getAndWriteProperty(HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM, outputProperties);
        HibernateSetup.getAndWriteProperty(HIBERNATE_CONNECTION_URL_PARAM, outputProperties);
        HibernateSetup.getAndWriteProperty(HIBERNATE_CONNECTION_USERNAME_PARAM, outputProperties);
        HibernateSetup.getAndWriteProperty(HIBERNATE_CONNECTION_PASSWORD_PARAM, outputProperties);
        HibernateSetup.getAndWriteProperty(DB_TABLE_NAME_PARAM, outputProperties);
        return outputProperties;
    }

    public static StandardServiceRegistry getStandardRegistry(Properties setupProperties) {
        StandardServiceRegistryBuilder standardRegistryBuilder = new StandardServiceRegistryBuilder();
        standardRegistryBuilder.applySettings((Map)setupProperties);
        return standardRegistryBuilder.build();
    }

    public static Metadata getHibernateStartupMetadata(Properties setupProperties, ServiceRegistry standardRegistry) {
        final String tableName = setupProperties.getProperty(DB_TABLE_NAME_PARAM);
        MetadataSources sources = new MetadataSources(standardRegistry).addAnnotatedClass(ApplicationRecoveryPod.class);
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        metadataBuilder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)new PhysicalNamingStrategyStandardImpl(){
            private static final long serialVersionUID = 1L;

            public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
                if (name.getCanonicalName().equalsIgnoreCase("RECOVERY_MARKER") && tableName != null && !tableName.isEmpty()) {
                    return Identifier.toIdentifier((String)tableName);
                }
                return name;
            }
        });
        return metadataBuilder.build();
    }

    public static String getTableName(Properties setupProperties) {
        String appRecoveryPodTableName = setupProperties.getProperty(DB_TABLE_NAME_PARAM);
        if (appRecoveryPodTableName == null) {
            appRecoveryPodTableName = "RECOVERY_MARKER";
        }
        return appRecoveryPodTableName;
    }

    public static boolean createTable(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.createOnly(EnumSet.of(TargetType.DATABASE), metadata);
        if (schemaExport.getExceptions() == null || schemaExport.getExceptions().isEmpty()) {
            I18NLogger.logger.error_schemaExportFailure(schemaExport.getExceptions());
            return false;
        }
        return true;
    }

    public static void close(SessionFactory sf, Session s) {
        if (s.isOpen()) {
            s.close();
        }
        if (!sf.isClosed()) {
            sf.close();
        }
    }

    private static Optional<String> getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String property = System.getProperty(key);
        if (property == null) {
            property = System.getenv(key);
        }
        if (property == null) {
            property = System.getProperty(key.toLowerCase().replaceAll("_", "."));
        }
        if (property == null) {
            property = System.getenv(key.toUpperCase().replaceAll("[.]", "_"));
        }
        return Optional.ofNullable(property);
    }

    private static Optional<String> getAndWriteProperty(String key, Properties propertiesToWriteIn) {
        Optional<String> value = HibernateSetup.getProperty(key);
        if (value.isPresent()) {
            propertiesToWriteIn.setProperty(key, value.get());
        }
        return value;
    }

    private static Properties setIfNotNull(String key, String value, Properties propertiesToChange) {
        if (key != null && value != null && !key.isEmpty() && !value.isEmpty()) {
            propertiesToChange.setProperty(key, value);
        }
        return propertiesToChange;
    }
}

