/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.ApplicationRecoveryPodHibernate5DAO;
import io.narayana.openshift.txrecovery.Hibernate5ProcessorMethods;
import io.narayana.openshift.txrecovery.Hibernate5Setup;
import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.hibernate.HibernateProperties;
import io.narayana.openshift.txrecovery.logging.I18NLogger;
import io.narayana.openshift.txrecovery.main.OutputPrinter;
import io.narayana.openshift.txrecovery.main.ProcessorMethods;
import io.narayana.openshift.txrecovery.main.ProgramProcessor;
import io.narayana.openshift.txrecovery.types.OutputFormatType;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ParsedArguments parsedArguments = null;
        try {
            parsedArguments = ParsedArguments.parse((String[])args);
        }
        catch (ArgumentParserException ape) {
            log.debugf((Throwable)ape, "Error on parsing arguments: %s", Arrays.asList(args));
            System.exit(1);
        }
        Properties setupProperties = HibernateProperties.setupPropertiesByParsedArguments((ParsedArguments)parsedArguments);
        log.infof("Hibernate setup properties to be used: %s", (Object)setupProperties);
        StandardServiceRegistry standardRegistry = Hibernate5Setup.getStandardRegistry(setupProperties);
        Metadata metadata = null;
        SessionFactory sessionFactory = null;
        Session session = null;
        try {
            metadata = Hibernate5Setup.getHibernateStartupMetadata(setupProperties, (ServiceRegistry)standardRegistry);
            sessionFactory = metadata.buildSessionFactory();
            session = sessionFactory.openSession();
        }
        catch (Throwable t) {
            I18NLogger.logger.error_toInitializeHibernate(t.getClass().getName() + ":" + t.getMessage());
            if (standardRegistry != null) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            }
            throw t;
        }
        List outputListing = null;
        try {
            ApplicationRecoveryPodHibernate5DAO dao = new ApplicationRecoveryPodHibernate5DAO(session);
            Hibernate5ProcessorMethods methods = new Hibernate5ProcessorMethods(dao, parsedArguments, setupProperties, metadata);
            outputListing = new ProgramProcessor((ProcessorMethods)methods).process(parsedArguments);
        }
        finally {
            Hibernate5Setup.close(sessionFactory, session);
            if (standardRegistry != null) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            }
        }
        OutputPrinter.printToStandardOutput((List)outputListing, (OutputFormatType)parsedArguments.getFormat());
    }
}

