package nashid.verify.sdk.mrtd2.activity

import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import nashid.verify.sdk.internetutility.ErrorUtility
import nashid.verify.sdk.mrtd2.locale.LocaleUtil
import nashid.verify.sdk.mrtd2.locale.Storage
import nashid.verify.sdk.utility.OnInternetAvailabilityListener

open class BaseActivity :
    AppCompatActivity(),
    OnInternetAvailabilityListener { // You can use your preferred activity instead of AppCompatActivity
    lateinit var storage: Storage
    private lateinit var oldPrefLocaleCode: String
    var isInternetAvailable: Boolean = true
    val tag = "BaseActivity"

    fun getPreferredLocale(context: Context): String {
        if (!::storage.isInitialized) {
            storage = Storage(context)
        }
        return storage.getPreferredLocale()
    }

    override fun onAvailable() {
        Log.d(tag, "onAvailable: ")
        isInternetAvailable = true
    }

    override fun onLost() {
        isInternetAvailable = false
        ErrorUtility.getInstance().showNoInternetDialog(
            this,
            !this.isFinishing && !this.isDestroyed,
        )
    }

    override fun onDestroy() {
        super.onDestroy()
        ErrorUtility.getInstance().unregisterConnectivityManager(this)
    }

    /**
     * updates the toolbar text locale if it set from the android:label property of Manifest
     */
    private fun resetTitle() {
        try {
            val label =
                packageManager.getActivityInfo(componentName, PackageManager.GET_META_DATA).labelRes
            if (label != 0) {
                setTitle(label)
            }
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }
    }

    override fun attachBaseContext(newBase: Context) {
        getPreferredLocale(newBase)
        oldPrefLocaleCode = Storage(newBase).getPreferredLocale()
        applyOverrideConfiguration(LocaleUtil.getLocalizedConfiguration(oldPrefLocaleCode))
        super.attachBaseContext(newBase)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        isInternetAvailable = ErrorUtility.getInstance().registerConnectivityManager(this, this)
        resetTitle()
        updateLayoutDirection()
    }

    private fun updateLayoutDirection() {
        val config = resources.configuration
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            if (config.layoutDirection == View.LAYOUT_DIRECTION_RTL) {
                window.decorView.layoutDirection = View.LAYOUT_DIRECTION_RTL
            } else {
                window.decorView.layoutDirection = View.LAYOUT_DIRECTION_LTR
            }
        }
    }

    override fun onResume() {
        val currentLocaleCode = Storage(this).getPreferredLocale()
        if (oldPrefLocaleCode != currentLocaleCode) {
            recreate() // locale is changed, restart the activity to update
            oldPrefLocaleCode = currentLocaleCode
        }
        super.onResume()
        isInternetAvailable = ErrorUtility.getInstance().registerConnectivityManager(this, this)
    }
}
