package nashid.verify.sdk.mrtd2.activity

import android.os.Bundle
import android.util.Log
import android.util.TypedValue
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.ImageView
import android.widget.LinearLayout
import com.caverock.androidsvg.SVG
import com.caverock.androidsvg.SVGParseException
import nashid.verify.sdk.NashidSDK
import nashid.verify.sdk.R
import nashid.verify.sdk.databinding.ActivitySdkSettingBinding
import nashid.verify.sdk.internetutility.ErrorUtility
import nashid.verify.sdk.mrtd2.rooted.RootedCheck
import nashid.verify.sdk.networking.APIClient
import nashid.verify.sdk.networking.APIInterface
import nashid.verify.sdk.networking.models.nashidfeaturecheck.NashidFeatureCheck
import nashid.verify.sdk.utility.SharePreferenceUtility
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

internal class SDKSettingScreen : BaseActivity() {
    private lateinit var binding: ActivitySdkSettingBinding
    private lateinit var lastSelectedFeature: String
    private var currentCall: Call<NashidFeatureCheck>? = null
    private var isApiCalled: Boolean = false

    companion object {
        const val SCAN = "Scan"
        const val NFC = "NFC"
        const val FACEMATCH = "Face-Match"
        const val LIVENESS = "Liveness"
    }

    override fun onAvailable() {
        Log.d("SDKSetting", "onAvailable: ")
        runOnUiThread(
            Runnable {
                if (!isApiCalled) {
                    callNashidFeatureCheckAPI()
                }
            },
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivitySdkSettingBinding.inflate(layoutInflater)
        setContentView(binding.root)
        RootedCheck.getInstance().setFlag(this@SDKSettingScreen)
        if (RootedCheck.getInstance().isRootedDevice(applicationContext)) {
            RootedCheck.getInstance().showRootedDeviceDialog(
                this,
                getString(R.string.root_dialog),
                getString(R.string.root_desc),
                getString(R.string.root_btn),
            )
        } else {
            setLayoutAndTextSize()
            callNashidFeatureCheckAPI()
            initClick()
        }
    }

    private fun deSelectAll() {
        binding.imgScan.setImageResource(R.drawable.radio_off)
        binding.imgScanNfc.setImageResource(R.drawable.radio_off)
        binding.imgScanLiveness.setImageResource(R.drawable.radio_off)
        binding.imgScanNfcLiveness.setImageResource(R.drawable.radio_off)
    }

    fun determineFeature(features: List<String>) {
        val combinations =
            listOf(
                arrayOf(SCAN, NFC, LIVENESS, FACEMATCH).toList(),
                arrayOf(SCAN, NFC, LIVENESS).toList(),
                arrayOf(SCAN, NFC, FACEMATCH).toList(),
                arrayOf(SCAN, NFC).toList(),
                arrayOf(SCAN, LIVENESS, FACEMATCH).toList(),
                arrayOf(SCAN, LIVENESS).toList(),
                arrayOf(SCAN, FACEMATCH).toList(),
                arrayOf(SCAN).toList(),
            )

        val preferences =
            mapOf(
                arrayOf(SCAN, NFC, LIVENESS, FACEMATCH).toList() to Pair(true, true),
                arrayOf(SCAN, NFC, LIVENESS).toList() to Pair(true, true),
                arrayOf(SCAN, NFC, FACEMATCH).toList() to Pair(true, true),
                arrayOf(SCAN, NFC).toList() to Pair(true, false),
                arrayOf(SCAN, LIVENESS, FACEMATCH).toList() to Pair(false, true),
                arrayOf(SCAN, LIVENESS).toList() to Pair(false, true),
                arrayOf(SCAN, FACEMATCH).toList() to Pair(false, true),
                arrayOf(SCAN).toList() to Pair(false, false),
            )

        val imageResources =
            mapOf(
                arrayOf(SCAN, NFC, LIVENESS, FACEMATCH).toList() to binding.imgScanNfcLiveness,
                arrayOf(SCAN, NFC, LIVENESS).toList() to binding.imgScanNfcLiveness,
                arrayOf(SCAN, NFC, FACEMATCH).toList() to binding.imgScanNfcLiveness,
                arrayOf(SCAN, NFC).toList() to binding.imgScanNfc,
                arrayOf(SCAN, LIVENESS, FACEMATCH).toList() to binding.imgScanLiveness,
                arrayOf(SCAN, LIVENESS).toList() to binding.imgScanLiveness,
                arrayOf(SCAN, FACEMATCH).toList() to binding.imgScanLiveness,
                arrayOf(SCAN).toList() to binding.imgScan,
            )

        val selectedFeature =
            mapOf(
                arrayOf(SCAN, NFC, LIVENESS, FACEMATCH).toList() to "Scan,NFC,Liveness,Face-Match",
                arrayOf(SCAN, NFC, LIVENESS).toList() to "Scan,NFC,Liveness",
                arrayOf(SCAN, NFC, FACEMATCH).toList() to "Scan,NFC,Face-Match",
                arrayOf(SCAN, NFC).toList() to "Scan,NFC",
                arrayOf(SCAN, LIVENESS, FACEMATCH).toList() to "Scan,Liveness,Face-Match",
                arrayOf(SCAN, LIVENESS).toList() to "Scan,Liveness",
                arrayOf(SCAN, FACEMATCH).toList() to "Scan,Face-Match",
                arrayOf(SCAN).toList() to "Scan",
            )

        for (combination in combinations) {
            Log.d("TAG", "determineFeature: " + combination + "  " + features)
            if (features.containsAll(combination)) {
                deSelectAll()

                // Set the appropriate image resource using the custom imageSetter function
                imageResources[combination]?.setImageResource(R.drawable.radio_on)
                lastSelectedFeature = selectedFeature[combination].toString()

                // Set preferences
                val preference = preferences[combination] ?: Pair(false, false)
                SharePreferenceUtility.savePreferenceValue(
                    applicationContext,
                    getString(R.string.sharepreference_nfc),
                    preference.first,
                )
                SharePreferenceUtility.savePreferenceValue(
                    applicationContext,
                    getString(R.string.sharepreference_facila_matching),
                    preference.second,
                )

                return // Exit the loop once the correct combination is found
            }
        }
    }

    private fun callNashidFeatureCheckAPI() {
        if (!isInternetAvailable) {
            ErrorUtility.getInstance().showNoInternetDialog(
                this,
                !this.isFinishing && !this.isDestroyed,
            )
        } else {
            binding.lytLoading.setVisibility(View.VISIBLE)
            Log.d("TAG", "callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL())
            if (!NashidSDK
                    .getInstance()
                    .getBaseURL()
                    .equals("", ignoreCase = true) &&
                !NashidSDK
                    .getInstance()
                    .getRegisterToken()
                    .equals("", ignoreCase = true)
            ) {
                APIClient
                    .getNashidFeatureCheckClient(
                        NashidSDK.getInstance().getBaseURL(),
                        NashidSDK.getInstance().getRegisterToken(),
                    ).create<APIInterface>(
                        APIInterface::class.java,
                    ).callNashidFeatureCheck(NashidSDK.getInstance().getCompanyUUID())
                    .enqueue(
                        object : Callback<NashidFeatureCheck> {
                            override fun onResponse(
                                call: Call<NashidFeatureCheck>,
                                response: Response<NashidFeatureCheck>,
                            ) {
                                Log.d(
                                    "TAG",
                                    """
                                    openScanDocumentScreen onResponse: ${response.isSuccessful}
                                    ${response.body()}
                                    """.trimIndent(),
                                )
                                try {
                                    if (response.isSuccessful) {
                                        isApiCalled = true
                                        val featureCheck = response.body()
                                        val allFeature = featureCheck!!.data.allFeatures
                                        val features = featureCheck.data.features
//                                val features = arrayListOf("Scan")
                                        Log.d("TAG", "onResponse:featurecheck $features\n$allFeature")

                                        determineFeature(features)
                                    } else {
                                    }
                                } catch (e: Exception) {
                                }
                                binding.lytLoading.setVisibility(View.GONE)
                            }

                            override fun onFailure(
                                call: Call<NashidFeatureCheck>,
                                t: Throwable,
                            ) {
                                binding.lytLoading.setVisibility(View.GONE)
                                Log.d("TAG", "openScanDocumentScreen onFailure: $t")
                            }
                        },
                    )
            } else {
                binding.lytLoading.setVisibility(View.GONE)
            }
        }
    }

    private fun callManageFeatureAPI(features: String) {
        Log.d("TAG", "callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL())
        if (!NashidSDK
                .getInstance()
                .getBaseURL()
                .equals("", ignoreCase = true) &&
            !NashidSDK
                .getInstance()
                .getRegisterToken()
                .equals("", ignoreCase = true)
        ) {
//            binding.lytLoading.setVisibility(View.VISIBLE)
            currentCall?.cancel()
            currentCall =
                APIClient
                    .getNashidFeatureCheckClient(
                        NashidSDK.getInstance().getBaseURL(),
                        NashidSDK.getInstance().getRegisterToken(),
                    ).create(
                        APIInterface::class.java,
                    ).callManageFeature(features, NashidSDK.getInstance().getCompanyUUID())
            currentCall?.enqueue(
                object : Callback<NashidFeatureCheck> {
                    override fun onResponse(
                        call: Call<NashidFeatureCheck>,
                        response: Response<NashidFeatureCheck>,
                    ) {
                        Log.d(
                            "TAG",
                            """
                            callNashidFeatureCheckAPIopenScanDocumentScreen onResponse: ${response.isSuccessful}
                            ${response.body()}
                            """.trimIndent(),
                        )
                        try {
                            if (response.isSuccessful) {
                                val featureCheck = response.body()
                                val allFeature = featureCheck!!.data.allFeatures
                                val feature = featureCheck.data.features
                                Log.d("TAG", "onResponse:managefeature $feature\n$allFeature")
//                            finish()
                            } else {
                            }
                        } catch (e: Exception) {
                        }
                    }

                    override fun onFailure(
                        call: Call<NashidFeatureCheck>,
                        t: Throwable,
                    ) {
                        Log.d("TAG", "openScanDocumentScreen onFailure: $t")
                    }
                },
            )
        } else {
            binding.lytLoading.setVisibility(View.GONE)
            finish()
        }
    }

    private fun initClick() {
        binding.lytHeaderMain.imgBack.setOnClickListener { view -> finish() }
        binding.lytScan.setOnClickListener(
            View.OnClickListener {
                handleClickofSelection(SCAN, binding.imgScan)
            },
        )
        binding.lytScanNfc.setOnClickListener(
            View.OnClickListener {
                handleClickofSelection("$SCAN,$NFC", binding.imgScanNfc)
            },
        )
        binding.lytScanLiveness.setOnClickListener(
            View.OnClickListener {
                handleClickofSelection("$SCAN,$LIVENESS,$FACEMATCH", binding.imgScanLiveness)
            },
        )
        binding.lytScanNfcLiveness.setOnClickListener(
            View.OnClickListener {
                handleClickofSelection("$SCAN,$NFC,$LIVENESS,$FACEMATCH", binding.imgScanNfcLiveness)
            },
        )
//        binding.btnSave.setOnClickListener { view ->
//            var feature = "Scan"
//            if (isNFCEnabled) {
//                feature = "$feature,NFC"
//            }
//            if (isFacialMatchingEnabled) {
//                feature = "$feature,Liveness"
//            }
//            callManageFeatureAPI(feature)
//        }
    }

    private fun handleClickofSelection(
        selectedOption: String,
        imageview: ImageView,
    ) {
        Log.d("TAG", "handleClickofSelection: " + selectedOption + "   " + lastSelectedFeature)
        if (lastSelectedFeature.equals(selectedOption)) {
            return
        }
        deSelectAll()
        imageview.setImageResource(R.drawable.radio_on)
        callManageFeatureAPI(selectedOption)
    }

    private fun setLayoutAndTextSize() {
        lastSelectedFeature = ""
        val textSizeConverter =
            TextSizeConverter(
                applicationContext,
            )
        textSizeConverter.changeStatusBarColor(this@SDKSettingScreen)
        var layoutParams2 = binding.lytHeaderMain.imgBack.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.lytHeaderMain.imgBack.layoutParams = layoutParams2
        if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
            binding.lytHeaderMain.imgBack.setRotation(180F)
        }
        var layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0)
        binding.lytHeaderMain.lytHeaderMain.layoutParams = layoutParams
        binding.lytHeaderMain.txtHelp.text = getString(R.string.sdk_setting_header)
        binding.lytHeaderMain.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(17),
        )
        binding.txtSelectVerification.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(32),
        )
        var padding = textSizeConverter.getPaddingORMarginValue(16)
        binding.lytSettingMain.setPadding(padding, padding, padding, padding)
        padding = textSizeConverter.getPaddingORMarginValue(24)
        binding.txtSelectVerification.setPadding(0, padding, 0, padding)

        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, 0, 0, 0)
        binding.lytScan.layoutParams = layoutParams
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0)
        binding.lytScanNfc.layoutParams = layoutParams
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0)
        binding.lytScanLiveness.layoutParams = layoutParams
        layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0)
        binding.lytScanNfcLiveness.layoutParams = layoutParams
        binding.txtScan.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18))
        binding.txtScanNfc.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(18),
        )
        binding.txtScanLiveness.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(18),
        )
        binding.txtScanNfcLiveness.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(18),
        )
        var imageSize = textSizeConverter.getWidth(20)
        layoutParams2 = binding.imgScan.layoutParams
        layoutParams2.width = imageSize
        layoutParams2.height = imageSize
        binding.imgScan.layoutParams = layoutParams2
        layoutParams2 = binding.imgScanNfc.layoutParams
        layoutParams2.width = imageSize
        layoutParams2.height = imageSize
        binding.imgScanNfc.layoutParams = layoutParams2
        layoutParams2 = binding.imgScanLiveness.layoutParams
        layoutParams2.width = imageSize
        layoutParams2.height = imageSize
        binding.imgScanLiveness.layoutParams = layoutParams2
        layoutParams2 = binding.imgScanNfcLiveness.layoutParams
        layoutParams2.width = imageSize
        layoutParams2.height = imageSize
        binding.imgScanNfcLiveness.layoutParams = layoutParams2
        padding = textSizeConverter.getPaddingORMarginValue(12)
        var back: SVG? = null
        try {
            back = SVG.getFromResource(resources, R.raw.back)
            binding.lytHeaderMain.imgBack.setSVG(back)
        } catch (e: SVGParseException) {
        }
        layoutParams2 = binding.imgLoader.getLayoutParams()
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.imgLoader.setLayoutParams(layoutParams2)
        val marginLyoutParam = binding.txtValidating.getLayoutParams() as LinearLayout.LayoutParams
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0)
        binding.txtValidating.setLayoutParams(marginLyoutParam)
        binding.txtValidating.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20),
        )
        val rotation = AnimationUtils.loadAnimation(this@SDKSettingScreen, R.anim.rotate)
        rotation.fillAfter = true
        binding.imgLoader.startAnimation(rotation)
    }
}
