package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;

import androidx.cardview.widget.CardView;

import nashid.verify.sdk.R;

public class TextSizeConverter {

    private final Context context;
    private final float scale;

    public TextSizeConverter(Context context) {
        this.context = context;
        scale = context.getResources().getDisplayMetrics().scaledDensity;
    }

    public float pxToSp(float px) {
        return px / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public float spToPx(float sp) {
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, sp, context.getResources().getDisplayMetrics());
    }

    public float convertPixelsToSp(float textSize) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return textSize / displayMetrics.scaledDensity;
    }

    public int getWidth(int width) {
        int desiredWidthInPixels = (int) (width * scale + 0.5f);
        return desiredWidthInPixels;
    }

    public int getHeight(int height) {
        int desiredHeightInPixels = (int) (height * scale + 0.5f);
        return desiredHeightInPixels;
    }

    public int getPaddingORMarginValue(int padding) {
        int desiredPaddingInPixels = (int) (padding * scale + 0.5f);
        return desiredPaddingInPixels;
    }

    public int calculateRadius(int radius) {
        int desiredRadiusInPixels = (int) (radius * scale + 0.5f);
        return desiredRadiusInPixels;
    }

    public LinearLayout.LayoutParams getLinearLayoutParam() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT, // Width (MATCH_PARENT or a specific width in pixels or dp)
                LinearLayout.LayoutParams.WRAP_CONTENT  // Height (MATCH_PARENT or a specific height in pixels or dp)
        );
        return layoutParams;
    }

    public LinearLayout.LayoutParams getMatchParentLinearLayoutParam() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT, // Width (MATCH_PARENT or a specific width in pixels or dp)
                LinearLayout.LayoutParams.MATCH_PARENT  // Height (MATCH_PARENT or a specific height in pixels or dp)
        );
        return layoutParams;
    }

    public CardView.LayoutParams getCardLayoutParam() {
        CardView.LayoutParams layoutParams = new CardView.LayoutParams(
                CardView.LayoutParams.MATCH_PARENT, // Width (MATCH_PARENT or a specific width in pixels or dp)
                CardView.LayoutParams.WRAP_CONTENT  // Height (MATCH_PARENT or a specific height in pixels or dp)
        );
        return layoutParams;
    }

    public float getTextSize(int textSize) {
//        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
//        float scaledTextSizeInPixels = TypedValue.applyDimension(
//                TypedValue.COMPLEX_UNIT_SP,
//                textSize,
//                metrics
//        );
        int desiredTextSizeInPixels = (int) (textSize * scale + 0.5f);
        return desiredTextSizeInPixels;
    }

    public void changeStatusBarColor(Activity activity) {
        // Change status bar color to white (if API level >= 21)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = activity.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(activity.getResources().getColor(android.R.color.white));
        }
        // Change status bar icons to black (if API level >= 23)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            View decorView = activity.getWindow().getDecorView();
            int flags = decorView.getSystemUiVisibility();
            flags |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
            decorView.setSystemUiVisibility(flags);
        }
    }

    public void changeProgressStatusBarColor(Activity activity) {
        // Change status bar color to white (if API level >= 21)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = activity.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(activity.getResources().getColor(R.color.loader_back));
        }
        // Change status bar icons to black (if API level >= 23)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            View decorView = activity.getWindow().getDecorView();
            int flags = decorView.getSystemUiVisibility();
            flags |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
            decorView.setSystemUiVisibility(flags);
        }
    }
}
