package nashid.verify.sdk.mrtd2.helpers

import android.util.Log
import nashid.verify.sdk.mrtd2.helpers.GeneralHelper.Companion.fuzzyMapping

class OmanIdCardReaderHelper {
    companion object {
        fun isSimilarEnough(
            a: String,
            b: String,
            threshold: Double,
        ): Boolean {
            val maxLength = maxOf(a.length, b.length)
            val distance = fuzzyMapping(a, b)
            val similarity = 1 - (distance.toDouble() / maxLength)
            Log.d("OmanIdCardReaderHelper", "maxLength:$maxLength, " + "distance:$distance, " + "similarity:$similarity")
            return similarity >= threshold
        }

        fun isSimilarEnough(input: String): Boolean = isSimilarEnough(input.uppercase(), b = "ROYAL OMAN POLICE D.G. OF CIVIL STATUS", threshold = 0.29)

        fun cleanString(input: String): String {
            if (input.length < 18) return ""
            Log.d("OmanIdCardReaderHelper", "length: " + input.length + ", input:$input")
            val groups =
                listOf(
                    input.substring(0, 7),
                    input.substring(7, 8),
                    input.substring(8, 15),
                    input.substring(15, 18),
                )

            val mappedGroups =
                groups.mapIndexed { index, group ->
                    when (index) {
                        0, 2 -> replaceAlfaWithNumber(group)
                        1, 3 -> replaceNumberWithAlfa(group)
                        else -> group
                    }
                }

            var result = mappedGroups.joinToString("")
            result += "<".repeat(29 - result.length)
            result += input.last()
            Log.d("OmanIdCardReaderHelper", "length: " + result.length + ", result:$result")
            return result
        }

        fun replaceNumberWithAlfa(str: String): String {
            val replacementDigitMap =
                mapOf(
                    '0' to 'O',
                    '1' to 'I',
                    '2' to 'Z',
                    '5' to 'S',
                    'r' to 'F',
                )
            return str.map { replacementDigitMap.getOrElse(it) { it } }.joinToString("")
        }

        fun replaceAlfaWithNumber(str: String): String {
            val replacementCharMap =
                mapOf(
                    'Z' to '2',
                    'S' to '5',
                    'I' to '1',
                    'O' to '0',
                    'B' to '8',
                    'T' to '1',
                )
            return str.map { replacementCharMap.getOrElse(it) { it } }.joinToString("")
        }
    }
}
