package nashid.verify.sdk.mrtd2.resultcallback.callbackclass;

public class ScanDocument {
    private String docuemntNo;
    private String dateOfBirth;
    private String expiryDate;

    @Override
    public String toString() {
        return "ScanDocument{" +
                "docuemntNo='" + docuemntNo + '\'' +
                ", dateOfBirth='" + dateOfBirth + '\'' +
                ", expiryDate='" + expiryDate + '\'' +
                '}';
    }

    private static volatile ScanDocument INSTANCE = null;

    // private constructor to prevent instantiation of the class
    private ScanDocument() {}

    public String getDocuemntNo() {
        return docuemntNo;
    }

    public void setDocuemntNo(String docuemntNo) {
        this.docuemntNo = docuemntNo;
    }

    public String getDateOfBirth() {
        return dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    // public static method to retrieve the singleton instance
    public static ScanDocument getInstance() {
        // Check if the instance is already created
        if(INSTANCE == null) {
            // synchronize the block to ensure only one thread can execute at a time
            synchronized (ScanDocument.class) {
                // check again if the instance is already created
                if (INSTANCE == null) {
                    // create the singleton instance
                    INSTANCE = new ScanDocument();
                }
            }
        }
        // return the singleton instance
        return INSTANCE;
    }
}
