package nashid.verify.sdk.networking;

import android.content.Context;
import android.util.Log;

import nashid.verify.sdk.Logger;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class APIClient {
    private static Retrofit retrofit = null;

    // load c++ library
    static {
        System.loadLibrary("native-lib");
//        System.loadLibrary("engine");
    }

    public static native String baseUrlFromJNI();


    public static native String autocropbaseUrlFromJNI();

    public static native String autoCropApiKey();

    public static native String amlAPI();

    public static native String autoCropApiSecretKey();

    public static native String baseGoogleUrlFromJNI();

    public static native String getToken();

    public static native String getAmlToken();

    private static int timeOut = 30;

    private final Logger logger = Logger.withTag(this.getClass().getSimpleName());

    public static Retrofit getClient(String identifier, String baseUrl) {
        baseUrl = determineBaseUrl(identifier, baseUrl);
//        Log.d("TAG", "getClient: " + identifier + "  " + baseUrl);
        if (identifier.equalsIgnoreCase("GoogleApi")) {
            return getGoogleApiClient();
        } else {
            return getCustomApiClient(identifier, baseUrl);
        }
    }

    private static Retrofit getCustomApiClient(String identifier, String baseUrl) {
        OkHttpClient client = createClient(identifier);
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(client)
                .build();
    }

    private static OkHttpClient createClient(String identifier) {
        if (identifier.equalsIgnoreCase("AML")) {
            return createAmlClient();
        } else if (identifier.equalsIgnoreCase("image crop")) {
            return createImageCropClient();
        } else {
            return createDefaultClient();
        }
    }

    private static OkHttpClient createImageCropClient() {
        // Create a client specifically for image crop service
        TrustManager[] trustManagers = new TrustManager[]{
                new X509TrustManager() {
                    @Override
                    public void checkClientTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws java.security.cert.CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws java.security.cert.CertificateException {
                    }

                    @Override
                    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                        return new java.security.cert.X509Certificate[]{};
                    }
                }
        };

        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            // Handle exceptions properly
        }

        return new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(getToken()))
                .sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager) trustManagers[0])
                .build();

    }

    private static OkHttpClient createDefaultClient() {
        // Create a default client for other services
        return new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(getToken()))
                .build();
    }

    private static OkHttpClient createAmlClient() {
        // Custom client setup for AML
        return new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(getAmlToken()))
                .build();
    }

    private static Retrofit getGoogleApiClient() {
        OkHttpClient client = createClientWithLogging();
        return new Retrofit.Builder()
                .baseUrl(baseGoogleUrlFromJNI())
                .addConverterFactory(GsonConverterFactory.create())
                .client(client)
                .build();
    }

    private static OkHttpClient createClientWithLogging() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(interceptor)
                .build();
    }

    public static Retrofit getFeatureCheckClient(String baseUrl, String token) {

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(token))
                .build();

        retrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();


        return retrofit;
    }

    public static Retrofit getNashidFeatureCheckClient(String baseUrl, String token) {

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(token))
                .build();
        Log.d("TAG", "getNashidFeatureCheckClient: " + baseUrl + "  " + token);
        retrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();


        return retrofit;
    }

    public static Retrofit getEmployeeTkenClient(String baseUrl, String token) {

        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)
                .addInterceptor(new AuthInterceptor(token))
                .build();

        retrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();


        return retrofit;
    }

    private static String determineBaseUrl(String identifier, String baseUrl) {
        if (baseUrl.isEmpty()) {
            switch (identifier) {
                case "image crop":
                    return autocropbaseUrlFromJNI();
                case "AML":
                    return amlAPI();
                default:
                    return baseUrlFromJNI();
            }
        }
        return baseUrl;
    }

    public static Retrofit getClient(Context context, String baseUrl, String token) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(timeOut, TimeUnit.SECONDS)
                .readTimeout(timeOut, TimeUnit.SECONDS)
                .writeTimeout(timeOut, TimeUnit.SECONDS)

                .addInterceptor(new AuthInterceptor(token))
                .build();

        retrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();
        return retrofit;
    }
}

