/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import icc.ICCProfile;
import java.io.IOException;
import java.util.Hashtable;
import jj2000.j2k.io.RandomAccessIO;

public abstract class JP2Box {
    public static final String eol = System.getProperty("line.separator");
    public static int type;
    public int length;
    protected RandomAccessIO in;
    protected int boxStart;
    protected int boxEnd;
    protected int dataStart;

    public static String getTypeString(int n) {
        return BoxType.get(n);
    }

    public JP2Box() throws ColorSpaceException {
        try {
            throw new ColorSpaceException("JP2Box empty ctor called!!");
        }
        catch (ColorSpaceException colorSpaceException) {
            colorSpaceException.printStackTrace();
            throw colorSpaceException;
        }
    }

    public JP2Box(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        byte[] byArray = new byte[16];
        this.in = randomAccessIO;
        this.boxStart = n;
        this.in.seek(this.boxStart);
        this.in.readFully(byArray, 0, 8);
        this.dataStart = n + 8;
        this.length = ICCProfile.getInt(byArray, 0);
        this.boxEnd = n + this.length;
        if (this.length == 1) {
            throw new ColorSpaceException("extended length boxes not supported");
        }
    }

    public String getTypeString() {
        return BoxType.get(type);
    }

    protected static class BoxType
    extends Hashtable {
        private static Hashtable map = new Hashtable();

        protected BoxType() {
        }

        private static void put(int n, String string) {
            map.put(new Integer(n), string);
        }

        public static String get(int n) {
            return (String)map.get(new Integer(n));
        }

        static {
            BoxType.put(1651532643, "BITS_PER_COMPONENT_BOX");
            BoxType.put(1919251299, "CAPTURE_RESOLUTION_BOX");
            BoxType.put(1667523942, "CHANNEL_DEFINITION_BOX");
            BoxType.put(1668246642, "COLOUR_SPECIFICATION_BOX");
            BoxType.put(1668112752, "COMPONENT_MAPPING_BOX");
            BoxType.put(1785737827, "CONTIGUOUS_CODESTREAM_BOX");
            BoxType.put(1919251300, "DEFAULT_DISPLAY_RESOLUTION_BOX");
            BoxType.put(1718909296, "FILE_TYPE_BOX");
            BoxType.put(1768449138, "IMAGE_HEADER_BOX");
            BoxType.put(1685074537, "INTELLECTUAL_PROPERTY_BOX");
            BoxType.put(1785737832, "JP2_HEADER_BOX");
            BoxType.put(1783636000, "JP2_SIGNATURE_BOX");
            BoxType.put(1885564018, "PALETTE_BOX");
            BoxType.put(1919251232, "RESOLUTION_BOX");
            BoxType.put(1970433056, "URL_BOX");
            BoxType.put(1970628964, "UUID_BOX");
            BoxType.put(1969843814, "UUID_INFO_BOX");
            BoxType.put(1969451892, "UUID_LIST_BOX");
            BoxType.put(2020437024, "XML_BOX");
        }
    }
}

