/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.quantizer;

import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class StdQuantizer
extends Quantizer {
    public static final int QSTEP_MANTISSA_BITS = 11;
    public static final int QSTEP_EXPONENT_BITS = 5;
    public static final int QSTEP_MAX_MANTISSA = 2047;
    public static final int QSTEP_MAX_EXPONENT = 31;
    private static double log2 = Math.log(2.0);
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private CBlkWTDataFloat infblk;

    public StdQuantizer(CBlkWTDataSrc cBlkWTDataSrc, EncoderSpecs encoderSpecs) {
        super(cBlkWTDataSrc);
        this.qts = encoderSpecs.qts;
        this.qsss = encoderSpecs.qsss;
        this.gbs = encoderSpecs.gbs;
    }

    public QuantTypeSpec getQuantTypeSpec() {
        return this.qts;
    }

    public int getNumGuardBits(int n, int n2) {
        return (Integer)this.gbs.getTileCompVal(n, n2);
    }

    public boolean isReversible(int n, int n2) {
        return this.qts.isReversible(n, n2);
    }

    public boolean isDerived(int n, int n2) {
        return this.qts.isDerived(n, n2);
    }

    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cBlkWTData) {
        return this.getNextInternCodeBlock(n, cBlkWTData);
    }

    public final CBlkWTData getNextInternCodeBlock(int n, CBlkWTData cBlkWTData) {
        int[] nArray;
        boolean bl;
        float[] fArray = null;
        int n2 = (Integer)this.gbs.getTileCompVal(this.tIdx, n);
        boolean bl2 = bl = this.src.getDataType(this.tIdx, n) == 3;
        if (cBlkWTData == null) {
            cBlkWTData = new CBlkWTDataInt();
        }
        CBlkWTDataFloat cBlkWTDataFloat = this.infblk;
        if (bl) {
            if ((cBlkWTData = this.src.getNextCodeBlock(n, cBlkWTData)) == null) {
                return null;
            }
            nArray = (int[])cBlkWTData.getData();
        } else {
            if ((cBlkWTDataFloat = (CBlkWTDataFloat)this.src.getNextInternCodeBlock(n, cBlkWTDataFloat)) == null) {
                this.infblk.setData(null);
                return null;
            }
            this.infblk = cBlkWTDataFloat;
            fArray = (float[])cBlkWTDataFloat.getData();
            nArray = (int[])cBlkWTData.getData();
            if (nArray == null || nArray.length < cBlkWTDataFloat.w * cBlkWTDataFloat.h) {
                nArray = new int[cBlkWTDataFloat.w * cBlkWTDataFloat.h];
                cBlkWTData.setData(nArray);
            }
            cBlkWTData.m = cBlkWTDataFloat.m;
            cBlkWTData.n = cBlkWTDataFloat.n;
            cBlkWTData.sb = cBlkWTDataFloat.sb;
            cBlkWTData.ulx = cBlkWTDataFloat.ulx;
            cBlkWTData.uly = cBlkWTDataFloat.uly;
            cBlkWTData.w = cBlkWTDataFloat.w;
            cBlkWTData.h = cBlkWTDataFloat.h;
            cBlkWTData.wmseScaling = cBlkWTDataFloat.wmseScaling;
            cBlkWTData.offset = 0;
            cBlkWTData.scanw = cBlkWTData.w;
        }
        int n3 = cBlkWTData.w;
        int n4 = cBlkWTData.h;
        SubbandAn subbandAn = cBlkWTData.sb;
        if (this.isReversible(this.tIdx, n)) {
            cBlkWTData.magbits = n2 - 1 + this.src.getNomRangeBits(n) + subbandAn.anGainExp;
            int n5 = 31 - cBlkWTData.magbits;
            cBlkWTData.convertFactor = 1 << n5;
            for (int i = n3 * n4 - 1; i >= 0; --i) {
                int n6 = nArray[i] << n5;
                nArray[i] = n6 < 0 ? Integer.MIN_VALUE | -n6 : n6;
            }
        } else {
            float f;
            float f2 = ((Float)this.qsss.getTileCompVal(this.tIdx, n)).floatValue();
            if (this.isDerived(this.tIdx, n)) {
                cBlkWTData.magbits = n2 - 1 + subbandAn.level - (int)Math.floor(Math.log(f2) / log2);
                f = f2 / (float)(1 << subbandAn.level);
            } else {
                cBlkWTData.magbits = n2 - 1 - (int)Math.floor(Math.log(f2 / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp))) / log2);
                f = f2 / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
            }
            int n7 = 31 - cBlkWTData.magbits;
            f = StdQuantizer.convertFromExpMantissa(StdQuantizer.convertToExpMantissa(f));
            float f3 = 1.0f / ((float)(1L << this.src.getNomRangeBits(n) + subbandAn.anGainExp) * f);
            cBlkWTData.convertFactor = f3 *= (float)(1 << n7 - this.src.getFixedPoint(n));
            cBlkWTData.stepSize = (float)(1L << this.src.getNomRangeBits(n) + subbandAn.anGainExp) * f;
            if (bl) {
                for (int i = n3 * n4 - 1; i >= 0; --i) {
                    int n8 = (int)((float)nArray[i] * f3);
                    nArray[i] = n8 < 0 ? Integer.MIN_VALUE | -n8 : n8;
                }
            } else {
                int n9 = n3 * n4 - 1;
                int n10 = cBlkWTDataFloat.offset + (n4 - 1) * cBlkWTDataFloat.scanw + n3 - 1;
                int n11 = n3 * (n4 - 1);
                while (n9 >= 0) {
                    while (n9 >= n11) {
                        int n12 = (int)(fArray[n10] * f3);
                        nArray[n9] = n12 < 0 ? Integer.MIN_VALUE | -n12 : n12;
                        --n10;
                        --n9;
                    }
                    n10 -= cBlkWTDataFloat.scanw - n3;
                    n11 -= n3;
                }
            }
        }
        return cBlkWTData;
    }

    protected void calcSbParams(SubbandAn subbandAn, int n) {
        if (subbandAn.stepWMSE > 0.0f) {
            return;
        }
        if (!subbandAn.isNode) {
            if (this.isReversible(this.tIdx, n)) {
                subbandAn.stepWMSE = (float)Math.pow(2.0, -(this.src.getNomRangeBits(n) << 1)) * subbandAn.l2Norm * subbandAn.l2Norm;
            } else {
                float f = ((Float)this.qsss.getTileCompVal(this.tIdx, n)).floatValue();
                subbandAn.stepWMSE = this.isDerived(this.tIdx, n) ? f * f * (float)Math.pow(2.0, subbandAn.anGainExp - subbandAn.level << 1) * subbandAn.l2Norm * subbandAn.l2Norm : f * f;
            }
        } else {
            this.calcSbParams((SubbandAn)subbandAn.getLL(), n);
            this.calcSbParams((SubbandAn)subbandAn.getHL(), n);
            this.calcSbParams((SubbandAn)subbandAn.getLH(), n);
            this.calcSbParams((SubbandAn)subbandAn.getHH(), n);
            subbandAn.stepWMSE = 1.0f;
        }
    }

    public static int convertToExpMantissa(float f) {
        int n = (int)Math.ceil(-Math.log(f) / log2);
        if (n > 31) {
            return 63488;
        }
        return n << 11 | (int)((-f * (float)(-1 << n) - 1.0f) * 2048.0f + 0.5f);
    }

    private static float convertFromExpMantissa(int n) {
        return (-1.0f - (float)(n & 0x7FF) / 2048.0f) / (float)(-1 << (n >> 11 & 0x1F));
    }

    public int getMaxMagBits(int n) {
        SubbandAn subbandAn = this.getAnSubbandTree(this.tIdx, n);
        if (this.isReversible(this.tIdx, n)) {
            return this.getMaxMagBitsRev(subbandAn, n);
        }
        if (this.isDerived(this.tIdx, n)) {
            return this.getMaxMagBitsDerived(subbandAn, this.tIdx, n);
        }
        return this.getMaxMagBitsExpounded(subbandAn, this.tIdx, n);
    }

    private int getMaxMagBitsRev(Subband subband, int n) {
        int n2 = 0;
        int n3 = (Integer)this.gbs.getTileCompVal(this.tIdx, n);
        if (!subband.isNode) {
            return n3 - 1 + this.src.getNomRangeBits(n) + subband.anGainExp;
        }
        n2 = this.getMaxMagBitsRev(subband.getLL(), n);
        int n4 = this.getMaxMagBitsRev(subband.getLH(), n);
        if (n4 > n2) {
            n2 = n4;
        }
        if ((n4 = this.getMaxMagBitsRev(subband.getHL(), n)) > n2) {
            n2 = n4;
        }
        if ((n4 = this.getMaxMagBitsRev(subband.getHH(), n)) > n2) {
            n2 = n4;
        }
        return n2;
    }

    private int getMaxMagBitsDerived(Subband subband, int n, int n2) {
        int n3 = 0;
        int n4 = (Integer)this.gbs.getTileCompVal(n, n2);
        if (!subband.isNode) {
            float f = ((Float)this.qsss.getTileCompVal(n, n2)).floatValue();
            return n4 - 1 + subband.level - (int)Math.floor(Math.log(f) / log2);
        }
        n3 = this.getMaxMagBitsDerived(subband.getLL(), n, n2);
        int n5 = this.getMaxMagBitsDerived(subband.getLH(), n, n2);
        if (n5 > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsDerived(subband.getHL(), n, n2)) > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsDerived(subband.getHH(), n, n2)) > n3) {
            n3 = n5;
        }
        return n3;
    }

    private int getMaxMagBitsExpounded(Subband subband, int n, int n2) {
        int n3 = 0;
        int n4 = (Integer)this.gbs.getTileCompVal(n, n2);
        if (!subband.isNode) {
            float f = ((Float)this.qsss.getTileCompVal(n, n2)).floatValue();
            return n4 - 1 - (int)Math.floor(Math.log(f / (((SubbandAn)subband).l2Norm * (float)(1 << subband.anGainExp))) / log2);
        }
        n3 = this.getMaxMagBitsExpounded(subband.getLL(), n, n2);
        int n5 = this.getMaxMagBitsExpounded(subband.getLH(), n, n2);
        if (n5 > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsExpounded(subband.getHL(), n, n2)) > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsExpounded(subband.getHH(), n, n2)) > n3) {
            n3 = n5;
        }
        return n3;
    }
}

