/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.jj2000;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import jj2000.j2k.codestream.writer.FileCodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import org.jmrtd.jj2000.Bitmap;
import org.jmrtd.jj2000.BitmapDataSrc;
import org.jmrtd.jj2000.MyFileFormatWriter;

public class JJ2000Encoder {
    private static final String[][] ENCODER_PINFO;

    static {
        String[][] stringArrayArray = new String[17][];
        String[] stringArray = new String[4];
        stringArray[0] = "debug";
        stringArray[2] = "";
        stringArray[3] = "off";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"disable_jp2_extension", "[on|off]", "", "off"};
        stringArrayArray[2] = new String[]{"file_format", "[on|off]", "", "on"};
        stringArrayArray[3] = new String[]{"pph_tile", "[on|off]", "", "off"};
        stringArrayArray[4] = new String[]{"pph_main", "[on|off]", "", "off"};
        String[] stringArray2 = new String[4];
        stringArray2[0] = "pfile";
        stringArray2[1] = "<filename of arguments file>";
        stringArray2[2] = "";
        stringArrayArray[5] = stringArray2;
        stringArrayArray[6] = new String[]{"tile_parts", "", "", "0"};
        stringArrayArray[7] = new String[]{"tiles", "<nominal tile width> <nominal tile height>", "", "0 0"};
        stringArrayArray[8] = new String[]{"ref", "<x> <y>", "", "0 0"};
        stringArrayArray[9] = new String[]{"tref", "<x> <y>", "", "0 0"};
        stringArrayArray[10] = new String[]{"rate", "<output bitrate in bpp>", "", "1.0"};
        stringArrayArray[11] = new String[]{"lossless", "[on|off]", "", "off"};
        String[] stringArray3 = new String[4];
        stringArray3[0] = "i";
        stringArray3[1] = "<image file> [,<image file> [,<image file> ... ]]";
        stringArray3[2] = "";
        stringArrayArray[12] = stringArray3;
        String[] stringArray4 = new String[4];
        stringArray4[0] = "o";
        stringArray4[1] = "<file name>";
        stringArray4[2] = "";
        stringArrayArray[13] = stringArray4;
        String[] stringArray5 = new String[4];
        stringArray5[0] = "verbose";
        stringArray5[2] = "";
        stringArray5[3] = "off";
        stringArrayArray[14] = stringArray5;
        stringArrayArray[15] = new String[]{"v", "[on|off]", "", "off"};
        stringArrayArray[16] = new String[]{"u", "[on|off]", "", "off"};
        ENCODER_PINFO = stringArrayArray;
    }

    private JJ2000Encoder() {
    }

    public static void encode(OutputStream outputStream, Bitmap bitmap, double bitRate) throws IOException {
        BitmapDataSrc imgsrc = new BitmapDataSrc(bitmap);
        String[][] pinfo = JJ2000Encoder.getAllEncoderParameters();
        ParameterList defpl = new ParameterList();
        int i = pinfo.length - 1;
        while (i >= 0) {
            if (pinfo[i][3] != null) {
                defpl.put(pinfo[i][0], pinfo[i][3]);
            }
            --i;
        }
        ParameterList pl = new ParameterList(defpl);
        pl.put("rate", Double.toString(bitRate));
        JJ2000Encoder.encode(imgsrc, outputStream, pl);
    }

    private static void encode(BlkImgDataSrc imgsrc, OutputStream fileOutputStream, ParameterList pl) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int tilesCount = 1;
        int componentCount = 3;
        EncoderSpecs encoderSpecs = new EncoderSpecs(tilesCount, componentCount, imgsrc, pl);
        int refx = 0;
        int refy = 0;
        int trefx = 0;
        int trefy = 0;
        int tw = imgsrc.getImgWidth();
        int th = imgsrc.getImgHeight();
        Tiler imgtiler = new Tiler(imgsrc, refx, refy, trefx, trefy, tw, th);
        ForwCompTransf fctransf = new ForwCompTransf(imgtiler, encoderSpecs);
        ImgDataConverter converter = new ImgDataConverter(fctransf);
        ForwardWT dwt = ForwardWT.createInstance(converter, pl, encoderSpecs);
        Quantizer quant = Quantizer.createInstance(dwt, encoderSpecs);
        ROIScaler rois = ROIScaler.createInstance(quant, pl, encoderSpecs);
        EntropyCoder ecoder = EntropyCoder.createInstance(rois, pl, encoderSpecs.cblks, encoderSpecs.pss, encoderSpecs.bms, encoderSpecs.mqrs, encoderSpecs.rts, encoderSpecs.css, encoderSpecs.sss, encoderSpecs.lcs, encoderSpecs.tts);
        FileCodestreamWriter bwriter = new FileCodestreamWriter(outputStream, Integer.MAX_VALUE);
        float rate = pl.getFloatParameter("rate");
        PostCompRateAllocator ralloc = PostCompRateAllocator.createInstance(ecoder, pl, rate, bwriter, encoderSpecs);
        int pktspertp = 0;
        boolean tempSop = false;
        boolean tempEph = false;
        boolean pphTile = false;
        boolean pphMain = false;
        if (pl.getParameter("tiles") == null) {
            System.err.println("No tiles option specified");
            return;
        }
        if (pl.getParameter("pph_tile").equals("on")) {
            pphTile = true;
            if (pl.getParameter("Psop").equals("off")) {
                pl.put("Psop", "on");
                tempSop = true;
            }
            if (pl.getParameter("Peph").equals("off")) {
                pl.put("Peph", "on");
                tempEph = true;
            }
        }
        if (pl.getParameter("pph_main").equals("on")) {
            pphMain = true;
            if (pl.getParameter("Psop").equals("off")) {
                pl.put("Psop", "on");
                tempSop = true;
            }
            if (pl.getParameter("Peph").equals("off")) {
                pl.put("Peph", "on");
                tempEph = true;
            }
        }
        if (pphTile && pphMain) {
            System.err.println("Can't have packed packet headers in both main and tile headers");
        }
        if (pl.getParameter("rate") == null) {
            System.err.println("Target bitrate not specified");
            return;
        }
        try {
            rate = pl.getFloatParameter("rate");
            if (rate == -1.0f) {
                rate = Float.MAX_VALUE;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid value in 'rate' option: " + pl.getParameter("rate"));
            if (pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                System.err.println("Use '-debug' option for more details");
            }
            return;
        }
        try {
            pktspertp = pl.getIntParameter("tile_parts");
            if (pktspertp != 0) {
                if (pl.getParameter("Psop").equals("off")) {
                    pl.put("Psop", "on");
                    tempSop = true;
                }
                if (pl.getParameter("Peph").equals("off")) {
                    pl.put("Peph", "on");
                    tempEph = true;
                }
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid value in 'tile_parts' option: " + pl.getParameter("tile_parts"));
            if (pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                System.err.println("Use '-debug' option for more details");
            }
            return;
        }
        boolean[] imsigned = new boolean[componentCount];
        int i = 0;
        while (i < componentCount) {
            imsigned[i] = true;
            ++i;
        }
        HeaderEncoder headenc = new HeaderEncoder(imgsrc, imsigned, dwt, imgtiler, encoderSpecs, rois, ralloc, pl);
        ralloc.setHeaderEncoder(headenc);
        headenc.encodeMainHeader();
        try {
            ralloc.initialize();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
        headenc.reset();
        headenc.encodeMainHeader();
        bwriter.commitBitstreamHeader(headenc);
        ralloc.runAndWrite();
        bwriter.close();
        int fileLength = bwriter.getLength();
        if (pktspertp > 0 || !pphTile) {
            // empty if block
        }
        int nc = imgsrc.getNumComps();
        int[] bpc = new int[nc];
        int comp = 0;
        while (comp < nc) {
            bpc[comp] = imgsrc.getNomRangeBits(comp);
            ++comp;
        }
        outputStream.flush();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        MyFileFormatWriter ffw = new MyFileFormatWriter(inputStream, fileOutputStream, imgsrc.getImgHeight(), imgsrc.getImgWidth(), nc, bpc, fileLength);
        fileLength += ffw.writeFileFormat();
    }

    private static String[][] getAllEncoderParameters() {
        int i;
        ArrayList<String[]> pl = new ArrayList<String[]>();
        String[][] str = ENCODER_PINFO;
        if (str != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = ForwCompTransf.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = AnWTFilter.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = ForwardWT.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = Quantizer.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = ROIScaler.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = EntropyCoder.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = HeaderEncoder.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = PostCompRateAllocator.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = PktEncoder.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = new String[pl.size()][4]) != null) {
            i = str.length - 1;
            while (i >= 0) {
                str[i] = (String[])pl.get(i);
                --i;
            }
        }
        return str;
    }
}

