/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.cbeff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import nashid.verify.sdk.id_card.jmrtd.cbeff.BiometricDataBlock;
import nashid.verify.sdk.id_card.jmrtd.cbeff.BiometricDataBlockEncoder;
import nashid.verify.sdk.id_card.jmrtd.cbeff.CBEFFInfo;
import nashid.verify.sdk.id_card.jmrtd.cbeff.ComplexCBEFFInfo;
import nashid.verify.sdk.id_card.jmrtd.cbeff.ISO781611;
import nashid.verify.sdk.id_card.jmrtd.cbeff.SimpleCBEFFInfo;
import nashid.verify.sdk.id_card.jmrtd.cbeff.StandardBiometricHeader;
import net.sf.scuba.tlv.TLVOutputStream;

public class ISO781611Encoder<B extends BiometricDataBlock>
implements ISO781611 {
    private final BiometricDataBlockEncoder<B> bdbEncoder;

    public ISO781611Encoder(BiometricDataBlockEncoder<B> bdbEncoder) {
        this.bdbEncoder = bdbEncoder;
    }

    public void encode(CBEFFInfo cbeffInfo, OutputStream outputStream) throws IOException {
        if (cbeffInfo instanceof SimpleCBEFFInfo) {
            this.writeBITGroup(List.of(new CBEFFInfo[]{cbeffInfo}), outputStream);
        } else if (cbeffInfo instanceof ComplexCBEFFInfo) {
            this.writeBITGroup(((ComplexCBEFFInfo)cbeffInfo).getSubRecords(), outputStream);
        }
    }

    private void writeBITGroup(List<CBEFFInfo> records, OutputStream outputStream) throws IOException {
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        tlvOut.writeTag(32609);
        tlvOut.writeTag(2);
        int count = records.size();
        tlvOut.writeValue(new byte[]{(byte)count});
        for (int index = 0; index < count; ++index) {
            SimpleCBEFFInfo simpleCBEFFInfo = (SimpleCBEFFInfo)records.get(index);
            this.writeBIT(tlvOut, index, simpleCBEFFInfo);
        }
        tlvOut.writeValueEnd();
    }

    private void writeBIT(TLVOutputStream tlvOutputStream, int index, SimpleCBEFFInfo<B> cbeffInfo) throws IOException {
        tlvOutputStream.writeTag(32608);
        this.writeBHT(tlvOutputStream, index, cbeffInfo);
        this.writeBiometricDataBlock(tlvOutputStream, cbeffInfo.getBiometricDataBlock());
        tlvOutputStream.writeValueEnd();
    }

    private void writeBHT(TLVOutputStream tlvOutputStream, int index, SimpleCBEFFInfo<B> cbeffInfo) throws IOException {
        tlvOutputStream.writeTag(161);
        B bdb = cbeffInfo.getBiometricDataBlock();
        StandardBiometricHeader sbh = bdb.getStandardBiometricHeader();
        SortedMap<Integer, byte[]> elements = sbh.getElements();
        for (Map.Entry<Integer, byte[]> entry : elements.entrySet()) {
            tlvOutputStream.writeTag(entry.getKey().intValue());
            tlvOutputStream.writeValue(entry.getValue());
        }
        tlvOutputStream.writeValueEnd();
    }

    private void writeBiometricDataBlock(TLVOutputStream tlvOutputStream, B bdb) throws IOException {
        tlvOutputStream.writeTag(24366);
        this.bdbEncoder.encode(bdb, (OutputStream)tlvOutputStream);
        tlvOutputStream.writeValueEnd();
    }
}

