/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.lds.SecurityInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLSequence;

public class ChipAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 5591988305059068535L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private final String oid;
    private final int version;
    private final BigInteger keyId;

    public ChipAuthenticationInfo(String oid, int version) {
        this(oid, version, null);
    }

    public ChipAuthenticationInfo(String oid, int version, BigInteger keyId) {
        this.oid = oid;
        this.version = version;
        this.keyId = keyId;
        this.checkFields();
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.oid));
        v.add((ASN1Encodable)new ASN1Integer((long)this.version));
        if (this.keyId != null) {
            v.add((ASN1Encodable)new ASN1Integer(this.keyId));
        }
        return new DLSequence(v);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    protected void checkFields() {
        try {
            if (!ChipAuthenticationInfo.checkRequiredIdentifier(this.oid)) {
                throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            }
            if (this.version != 1 && this.version != 2) {
                throw new IllegalArgumentException("Wrong version. Was expecting 1 or 2, found " + this.version);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected exception", e);
            throw new IllegalArgumentException("Malformed ChipAuthenticationInfo.");
        }
    }

    static boolean checkRequiredIdentifier(String oid) {
        return ID_CA_DH_3DES_CBC_CBC.equals(oid) || ID_CA_ECDH_3DES_CBC_CBC.equals(oid) || "0.4.0.127.0.7.2.2.3.1.2".equals(oid) || "0.4.0.127.0.7.2.2.3.1.3".equals(oid) || "0.4.0.127.0.7.2.2.3.1.4".equals(oid) || "0.4.0.127.0.7.2.2.3.2.2".equals(oid) || "0.4.0.127.0.7.2.2.3.2.3".equals(oid) || "0.4.0.127.0.7.2.2.3.2.4".equals(oid);
    }

    public String toString() {
        return "ChipAuthenticationInfo [protocol: " + ChipAuthenticationInfo.toProtocolOIDString(this.oid) + ", version: " + this.version + ", keyId: " + (this.keyId == null ? "-" : this.keyId) + "]";
    }

    public int hashCode() {
        return 3 + 11 * (this.oid == null ? 0 : this.oid.hashCode()) + 61 * this.version + 1991 * (this.keyId == null ? 111 : this.keyId.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!ChipAuthenticationInfo.class.equals(other.getClass())) {
            return false;
        }
        ChipAuthenticationInfo otherChipAuthenticationInfo = (ChipAuthenticationInfo)other;
        return this.oid.equals(otherChipAuthenticationInfo.oid) && this.version == otherChipAuthenticationInfo.version && (this.keyId == null && otherChipAuthenticationInfo.keyId == null || this.keyId != null && this.keyId.equals(otherChipAuthenticationInfo.keyId));
    }

    public static String toKeyAgreementAlgorithm(String oid) {
        if (oid == null) {
            throw new NumberFormatException("Unknown OID: null");
        }
        if (ID_CA_DH_3DES_CBC_CBC.equals(oid) || "0.4.0.127.0.7.2.2.3.1.2".equals(oid) || "0.4.0.127.0.7.2.2.3.1.3".equals(oid) || "0.4.0.127.0.7.2.2.3.1.4".equals(oid)) {
            return "DH";
        }
        if (ID_CA_ECDH_3DES_CBC_CBC.equals(oid) || "0.4.0.127.0.7.2.2.3.2.2".equals(oid) || "0.4.0.127.0.7.2.2.3.2.3".equals(oid) || "0.4.0.127.0.7.2.2.3.2.4".equals(oid)) {
            return "ECDH";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static String toCipherAlgorithm(String oid) {
        if (ID_CA_DH_3DES_CBC_CBC.equals(oid) || ID_CA_ECDH_3DES_CBC_CBC.equals(oid)) {
            return "DESede";
        }
        if ("0.4.0.127.0.7.2.2.3.1.2".equals(oid) || "0.4.0.127.0.7.2.2.3.1.3".equals(oid) || "0.4.0.127.0.7.2.2.3.1.4".equals(oid) || "0.4.0.127.0.7.2.2.3.2.2".equals(oid) || "0.4.0.127.0.7.2.2.3.2.3".equals(oid) || "0.4.0.127.0.7.2.2.3.2.4".equals(oid)) {
            return "AES";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static String toDigestAlgorithm(String oid) {
        if (ID_CA_DH_3DES_CBC_CBC.equals(oid) || ID_CA_ECDH_3DES_CBC_CBC.equals(oid) || "0.4.0.127.0.7.2.2.3.1.2".equals(oid) || "0.4.0.127.0.7.2.2.3.2.2".equals(oid)) {
            return "SHA-1";
        }
        if ("0.4.0.127.0.7.2.2.3.1.3".equals(oid) || "0.4.0.127.0.7.2.2.3.2.3".equals(oid) || "0.4.0.127.0.7.2.2.3.1.4".equals(oid) || "0.4.0.127.0.7.2.2.3.2.4".equals(oid)) {
            return "SHA-256";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static int toKeyLength(String oid) {
        if (ID_CA_DH_3DES_CBC_CBC.equals(oid) || ID_CA_ECDH_3DES_CBC_CBC.equals(oid) || "0.4.0.127.0.7.2.2.3.1.2".equals(oid) || "0.4.0.127.0.7.2.2.3.2.2".equals(oid)) {
            return 128;
        }
        if ("0.4.0.127.0.7.2.2.3.1.3".equals(oid) || "0.4.0.127.0.7.2.2.3.2.3".equals(oid)) {
            return 192;
        }
        if ("0.4.0.127.0.7.2.2.3.1.4".equals(oid) || "0.4.0.127.0.7.2.2.3.2.4".equals(oid)) {
            return 256;
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    private static String toProtocolOIDString(String oid) {
        if (ID_CA_DH_3DES_CBC_CBC.equals(oid)) {
            return "id-CA-DH-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.3.1.2".equals(oid)) {
            return "id-CA-DH-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.3.1.3".equals(oid)) {
            return "id-CA-DH-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.3.1.4".equals(oid)) {
            return "id-CA-DH-AES-CBC-CMAC-256";
        }
        if (ID_CA_ECDH_3DES_CBC_CBC.equals(oid)) {
            return "id-CA-ECDH-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.3.2.2".equals(oid)) {
            return "id-CA-ECDH-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.3.2.3".equals(oid)) {
            return "id-CA-ECDH-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.3.2.4".equals(oid)) {
            return "id-CA-ECDH-AES-CBC-CMAC-256";
        }
        return oid;
    }
}

