/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.lds.DataGroup;
import nashid.verify.sdk.id_card.jmrtd.lds.DisplayedImageInfo;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public abstract class DisplayedImageDataGroup
extends DataGroup {
    private static final long serialVersionUID = 5994136177872308962L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final int DISPLAYED_IMAGE_COUNT_TAG = 2;
    private int displayedImageTagToUse;
    private List<DisplayedImageInfo> imageInfos;

    public DisplayedImageDataGroup(int dataGroupTag, List<DisplayedImageInfo> imageInfos, int displayedImageTagToUse) {
        super(dataGroupTag);
        if (imageInfos == null) {
            throw new IllegalArgumentException("imageInfos cannot be null");
        }
        this.displayedImageTagToUse = displayedImageTagToUse;
        this.imageInfos = new ArrayList<DisplayedImageInfo>(imageInfos);
        this.checkTypesConsistentWithTag();
    }

    public DisplayedImageDataGroup(int dataGroupTag, InputStream inputStream) throws IOException {
        super(dataGroupTag, inputStream);
        if (this.imageInfos == null) {
            this.imageInfos = new ArrayList<DisplayedImageInfo>();
        }
        this.checkTypesConsistentWithTag();
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int countTag = tlvIn.readTag();
        if (countTag != 2) {
            throw new IllegalArgumentException("Expected tag 0x02 in displayed image structure, found " + Integer.toHexString(countTag));
        }
        int countLength = tlvIn.readLength();
        if (countLength != 1) {
            throw new IllegalArgumentException("DISPLAYED_IMAGE_COUNT should have length 1");
        }
        int count = tlvIn.readValue()[0] & 0xFF;
        for (int i = 0; i < count; ++i) {
            DisplayedImageInfo imageInfo = new DisplayedImageInfo((InputStream)tlvIn);
            if (i == 0) {
                this.displayedImageTagToUse = imageInfo.getDisplayedImageTag();
            } else if (imageInfo.getDisplayedImageTag() != this.displayedImageTagToUse) {
                throw new IOException("Found images with different displayed image tags inside displayed image datagroup");
            }
            this.add(imageInfo);
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        tlvOut.writeTag(2);
        tlvOut.writeValue(new byte[]{(byte)this.imageInfos.size()});
        for (DisplayedImageInfo imageInfo : this.imageInfos) {
            imageInfo.writeObject((OutputStream)tlvOut);
        }
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getClass().getSimpleName());
        result2.append(" [");
        boolean isFirst = true;
        if (this.imageInfos == null) {
            throw new IllegalStateException("imageInfos cannot be null");
        }
        for (DisplayedImageInfo info : this.imageInfos) {
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(", ");
            }
            result2.append(info.toString());
        }
        result2.append("]");
        return result2.toString();
    }

    public int hashCode() {
        return 1337 + (this.imageInfos == null ? 1 : this.imageInfos.hashCode()) + 31337;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DisplayedImageDataGroup otherDG = (DisplayedImageDataGroup)other;
        return Objects.equals(this.imageInfos, otherDG.imageInfos);
    }

    public List<DisplayedImageInfo> getImages() {
        return new ArrayList<DisplayedImageInfo>(this.imageInfos);
    }

    private void add(DisplayedImageInfo image) {
        if (this.imageInfos == null) {
            this.imageInfos = new ArrayList<DisplayedImageInfo>();
        }
        this.imageInfos.add(image);
    }

    private void checkTypesConsistentWithTag() {
        block4: for (DisplayedImageInfo imageInfo : this.imageInfos) {
            if (imageInfo == null) {
                throw new IllegalArgumentException("Found a null image info");
            }
            switch (imageInfo.getType()) {
                case 1: {
                    if (this.displayedImageTagToUse == 24387) continue block4;
                    throw new IllegalArgumentException("'Portrait' image cannot be part of a 'Signature or usual mark' displayed image datagroup");
                }
                case 0: {
                    if (this.displayedImageTagToUse == 24384) continue block4;
                    throw new IllegalArgumentException("'Signature or usual mark' image cannot be part of a 'Portrait' displayed image datagroup");
                }
            }
            LOGGER.warning("Unsupported image type");
        }
    }
}

