/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import nashid.verify.sdk.id_card.jmrtd.APDULevelEACTACapable;
import nashid.verify.sdk.id_card.jmrtd.protocol.SecureMessagingAPDUSender;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class EACTAAPDUSender
implements APDULevelEACTACapable {
    private final SecureMessagingAPDUSender secureMessagingSender;

    public EACTAAPDUSender(CardService service) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(service);
    }

    @Override
    public synchronized void sendMSESetDST(APDUWrapper wrapper, byte[] data) throws CardServiceException {
        CommandAPDU capdu = new CommandAPDU(0, 34, 129, 182, data);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending MSE Set DST failed", (int)sw);
        }
    }

    @Override
    public synchronized void sendPSOExtendedLengthMode(APDUWrapper wrapper, byte[] certBodyData, byte[] certSignatureData) throws CardServiceException {
        byte[] certData = new byte[certBodyData.length + certSignatureData.length];
        System.arraycopy(certBodyData, 0, certData, 0, certBodyData.length);
        System.arraycopy(certSignatureData, 0, certData, certBodyData.length, certSignatureData.length);
        CommandAPDU capdu = new CommandAPDU(0, 42, 0, 190, certData);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending PSO failed", (int)sw);
        }
    }

    @Override
    public synchronized void sendMSESetATExtAuth(APDUWrapper wrapper, byte[] data) throws CardServiceException {
        CommandAPDU capdu = new CommandAPDU(0, 34, 129, 164, data);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending MSE AT failed", (int)sw);
        }
    }

    @Override
    public synchronized byte[] sendGetChallenge(APDUWrapper wrapper) throws CardServiceException {
        CommandAPDU capdu = new CommandAPDU(0, -124, 0, 0, 8);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        return rapdu.getData();
    }

    @Override
    public synchronized void sendMutualAuthenticate(APDUWrapper wrapper, byte[] signature) throws CardServiceException {
        CommandAPDU capdu = new CommandAPDU(0, -126, 0, 0, signature);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending External Authenticate failed.", (int)sw);
        }
    }
}

