/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.BitiMRTD.Reader;

import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import nashid.verify.sdk.mrtd2.BitiAndroid.TagProvider;
import nashid.verify.sdk.mrtd2.BitiMRTD.NFC.Apdu;
import nashid.verify.sdk.mrtd2.BitiMRTD.NFC.Doc9303Apdu;
import nashid.verify.sdk.mrtd2.BitiMRTD.Reader.BacInfo;
import nashid.verify.sdk.mrtd2.BitiMRTD.Reader.ProgressListenerInterface;
import nashid.verify.sdk.mrtd2.BitiMRTD.Tools.Crypto;
import nashid.verify.sdk.mrtd2.BitiMRTD.Tools.Tools;

public abstract class AbstractReader {
    protected byte[] selectBacChallenge = new byte[]{0, -124, 0, 0, 8};
    protected byte[] sessionEncKey = null;
    protected byte[] sessionMacKey = null;
    protected byte[] sequenceCounter = null;
    protected Tools tools;
    protected Apdu apdu;
    protected Crypto crypto;
    protected Doc9303Apdu doc9303Apdu;
    protected BacInfo bacInfo = null;
    protected WeakReference<Object> progressListener;
    protected int readingAttempsFails = 0;
    protected int maxBlockSize = 215;
    protected byte mutualAuthLe = (byte)40;

    public void incrementSequenceCounter() {
        this.sequenceCounter = this.tools.incrementBytesArray(this.sequenceCounter);
    }

    public AbstractReader() {
        this.tools = new Tools();
        this.apdu = new Apdu();
        this.crypto = new Crypto();
        this.doc9303Apdu = new Doc9303Apdu();
        try {
            byte[] result2 = TagProvider.transceive(this.doc9303Apdu.getAID());
            System.out.println("Select AID : ".concat(this.tools.bytesToString(result2)));
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public void setProgressListener(WeakReference<Object> progressListener) {
        this.progressListener = progressListener;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public void setApduWithLe(boolean value) {
        this.apdu.setApduWithLe(value);
    }

    public void setMutualAuthLe(byte mutualAuthLe) {
        this.mutualAuthLe = mutualAuthLe;
    }

    public abstract byte[] encrypt(byte[] var1, byte[] var2);

    public abstract byte[] decrypt(byte[] var1, byte[] var2);

    public abstract byte[] calculateMac(byte[] var1, byte[] var2, boolean var3);

    public abstract byte[] calculateMac(byte[] var1, byte[] var2);

    public abstract byte[] calculateSequenceCounter(byte[] var1);

    public abstract byte[] padData(byte[] var1);

    public abstract byte[] calculateEncryptionKey(byte[] var1);

    public byte[] getBacChallenge() {
        try {
            byte[] result2 = TagProvider.transceive(this.selectBacChallenge);
            if (result2 == null || result2.length < 10) {
                System.out.println("Expected at least 10 bytes response, got : ".concat(this.tools.bytesToString(result2)));
                return null;
            }
            if (result2[8] != -112 || result2[9] != 0) {
                System.out.println("Expected SWR 1-2 to be 0x9000");
            }
            System.out.println("Got challenge : ".concat(this.tools.bytesToString(result2)));
            return Arrays.copyOfRange(result2, 0, 8);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            return null;
        }
    }

    public boolean initSession() {
        return this.initSession(20000);
    }

    public boolean initSession(int mutualAuthTimeout) {
        if (this.bacInfo == null) {
            System.out.println("bac info needs to be set");
            return false;
        }
        byte[] challenge = this.getBacChallenge();
        byte[] random8 = this.crypto.generateRandomBytes(8);
        byte[] kIFD = this.crypto.generateRandomBytes(16);
        byte[] s = this.tools.concatByteArrays(random8, challenge);
        s = this.tools.concatByteArrays(s, kIFD);
        System.out.println("S : ".concat(this.tools.bytesToString(s)));
        byte[] seed = this.crypto.calculateSeed(this.bacInfo.getPassportNbr(), this.bacInfo.getDateOfBirth(), this.bacInfo.getDateOfExpiry());
        byte[] encryptionKey = this.calculateEncryptionKey(seed);
        byte[] macKey = this.crypto.calculateMacKey(seed);
        byte[] eifd = this.encrypt(encryptionKey, s);
        System.out.println("eifd : ".concat(this.tools.bytesToString(eifd)));
        byte[] desMac = this.calculateMac(macKey, eifd);
        byte[] cmdData = this.tools.concatByteArrays(eifd, desMac);
        byte[] cmd = this.apdu.buildApduCommand((byte)0, (byte)-126, (byte)0, (byte)0, cmdData, this.mutualAuthLe);
        long before = System.currentTimeMillis();
        int previousTimeout = TagProvider.getTimeout();
        TagProvider.setTimeout(previousTimeout + mutualAuthTimeout);
        try {
            System.out.println("Max tranceivalable length: ".concat(String.valueOf(TagProvider.getMaxTransceiveLength())));
            byte[] result2 = TagProvider.transceive(cmd);
            System.out.println("Succeeded in: ".concat(String.valueOf(System.currentTimeMillis() - before)));
            System.out.println("SESSION RESULT: ".concat(this.tools.bytesToString(result2)));
            TagProvider.setTimeout(previousTimeout);
            if (result2 == null || result2.length < 42) {
                System.out.println("BAC FAILED!");
                return false;
            }
            byte[] payload = Arrays.copyOfRange(result2, 0, 32);
            byte[] decryptedPayload = this.decrypt(encryptionKey, payload);
            System.out.println("Decrypted payload: ".concat(this.tools.bytesToString(decryptedPayload)));
            byte[] sessionSeed = this.tools.doXor(kIFD, Arrays.copyOfRange(decryptedPayload, 16, 32));
            System.out.println("Session seed: ".concat(this.tools.bytesToString(sessionSeed)));
            this.sessionEncKey = this.calculateEncryptionKey(sessionSeed);
            this.sessionMacKey = this.crypto.calculateMacKey(sessionSeed);
            this.sequenceCounter = this.calculateSequenceCounter(decryptedPayload);
            return true;
        }
        catch (Exception e) {
            System.out.println("Failed in: ".concat(String.valueOf(System.currentTimeMillis() - before)));
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.out.println(Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public void setBacInfo(BacInfo bacInfo) {
        this.bacInfo = bacInfo;
    }

    private boolean selectFile(byte[] file) {
        if (this.sessionEncKey == null || this.sessionMacKey == null) {
            System.out.println("Session key is empty");
            return false;
        }
        System.out.println("Step 1, select FILE");
        byte[] cmdHeader = new byte[]{12, -92, 2, 12};
        cmdHeader = this.padData(cmdHeader);
        byte[] paddedQuery = this.padData(file);
        System.out.println("paddedQuery : ".concat(this.tools.bytesToString(paddedQuery)));
        byte[] encryptedQuery = this.encrypt(this.sessionEncKey, paddedQuery);
        byte[] do87 = this.doc9303Apdu.buildDO87(encryptedQuery);
        System.out.println("do87 : ".concat(this.tools.bytesToString(do87)));
        byte[] m = this.tools.concatByteArrays(cmdHeader, do87);
        this.incrementSequenceCounter();
        byte[] n = this.padData(this.tools.concatByteArrays(this.sequenceCounter, m));
        byte[] cc = this.calculateMac(this.sessionMacKey, n, false);
        byte[] do8e = this.doc9303Apdu.buildDO8E(cc);
        byte[] protectedApdu = this.apdu.buildApduCommand((byte)12, (byte)-92, (byte)2, (byte)12, this.tools.concatByteArrays(do87, do8e), (byte)0);
        try {
            byte[] rapdu = TagProvider.transceive(protectedApdu);
            System.out.println("rapdu : ".concat(this.tools.bytesToString(rapdu)));
            this.incrementSequenceCounter();
            return true;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.out.println(Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public byte[] readFile(byte[] file) {
        if (this.progressListener != null && this.progressListener.get() instanceof ProgressListenerInterface && ((ProgressListenerInterface)this.progressListener.get()).isCanceled()) {
            return null;
        }
        return this.readFileStep1(file);
    }

    private byte[] readFileStep1(byte[] file) {
        if (this.sessionEncKey == null || this.sessionMacKey == null) {
            System.out.println("Session key is empty");
            return null;
        }
        if (this.selectFile(file)) {
            return this.readFileStep2(file);
        }
        return null;
    }

    private byte[] readFileStep2(byte[] file) {
        System.out.println("Step 2, read first 4 bytes of FILE");
        byte[] cmdHeader = new byte[]{12, -80, 0, 0};
        cmdHeader = this.padData(cmdHeader);
        byte[] do97 = this.doc9303Apdu.buildDO97(4);
        System.out.println("do97 : ".concat(this.tools.bytesToString(do97)));
        byte[] m = this.tools.concatByteArrays(cmdHeader, do97);
        this.incrementSequenceCounter();
        byte[] n = this.tools.concatByteArrays(this.sequenceCounter, m);
        n = this.padData(n);
        byte[] cc = this.calculateMac(this.sessionMacKey, n, false);
        byte[] do8e = this.doc9303Apdu.buildDO8E(cc);
        byte[] protectedApdu = this.apdu.buildApduCommand((byte)12, (byte)-80, (byte)0, (byte)0, this.tools.concatByteArrays(do97, do8e), (byte)0);
        try {
            byte[] rapdu = TagProvider.transceive(protectedApdu);
            this.incrementSequenceCounter();
            if (rapdu != null && rapdu.length >= 5) {
                if (rapdu[0] != -121 || rapdu[2] != 1) {
                    System.out.println("Expected DO87 response");
                    return null;
                }
                byte responseLength = rapdu[1];
                System.out.println("Response length : ".concat(String.valueOf(responseLength)));
                byte[] encryptedPayload = Arrays.copyOfRange(rapdu, 3, 2 + responseLength);
                byte[] decryptedPayload = this.decrypt(this.sessionEncKey, encryptedPayload);
                byte[] unpadedResult = this.tools.unpadData(decryptedPayload);
                byte[] fileContent = this.readFileStep3(file, unpadedResult);
                if (fileContent == null) {
                    return null;
                }
                return this.tools.concatByteArrays(unpadedResult, fileContent);
            }
            System.out.println("Response size too small");
            return null;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.out.println(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    private byte[] readFileStep3(byte[] file, byte[] fileHeader) {
        System.out.println("Step 3, read entire FILE");
        int cursor = 4;
        int fileLength = this.tools.getLengthFromFileHeader(fileHeader);
        System.out.println("File length : ".concat(String.valueOf(fileLength)));
        byte[] fileContent = new byte[]{};
        if (fileLength < 128) {
            fileLength += 2;
        } else if (fileLength < 256) {
            fileLength += 3;
        } else if (fileLength < 65536) {
            fileLength += 4;
        }
        while (cursor < fileLength) {
            byte[] fileChunk;
            int le = this.maxBlockSize;
            if (cursor + le > fileLength) {
                le = fileLength - cursor;
            }
            if ((fileChunk = this.readFileStep3(file, cursor, le)) == null) {
                if (this.progressListener != null && this.progressListener.get() instanceof ProgressListenerInterface && ((ProgressListenerInterface)this.progressListener.get()).isCanceled()) {
                    return null;
                }
                if (this.readingAttempsFails >= 1) {
                    return null;
                }
                System.out.println("Seems that we lost the connection, trying to reinitialize the session");
                this.initSession(TagProvider.getTimeout());
                this.selectFile(file);
                ++this.readingAttempsFails;
            } else {
                cursor += le;
                fileContent = this.tools.concatByteArrays(fileContent, fileChunk);
                this.readingAttempsFails = 0;
            }
            if (this.progressListener == null || !(this.progressListener.get() instanceof ProgressListenerInterface)) continue;
            if (((ProgressListenerInterface)this.progressListener.get()).isCanceled()) {
                return null;
            }
            ((ProgressListenerInterface)this.progressListener.get()).updateProgress(Math.round(100 * cursor / fileLength));
        }
        return fileContent;
    }

    private byte[] readFileStep3(byte[] file, int cursor, int le) {
        System.out.println("Step 3, read entire FILE, cursor at : ".concat(String.valueOf(cursor)));
        System.out.println("le : ".concat(String.valueOf(le)));
        byte[] bytesCursor = this.tools.calculate2bytesInt(cursor);
        byte[] cmdHeader = new byte[]{12, -80, bytesCursor[0], bytesCursor[1]};
        cmdHeader = this.padData(cmdHeader);
        byte[] do97 = this.doc9303Apdu.buildDO97(le);
        byte[] m = this.tools.concatByteArrays(cmdHeader, do97);
        this.incrementSequenceCounter();
        byte[] n = this.tools.concatByteArrays(this.sequenceCounter, m);
        n = this.padData(n);
        byte[] cc = this.calculateMac(this.sessionMacKey, n, false);
        byte[] do8e = this.doc9303Apdu.buildDO8E(cc);
        byte[] protectedApdu = this.apdu.buildApduCommand((byte)12, (byte)-80, bytesCursor[0], bytesCursor[1], this.tools.concatByteArrays(do97, do8e), (byte)0);
        try {
            byte[] rapdu = TagProvider.transceive(protectedApdu);
            this.incrementSequenceCounter();
            if (rapdu == null || rapdu.length < 4) {
                System.out.println("Error, expected at least 4 bytes, got : ".concat(this.tools.bytesToString(rapdu)));
                return null;
            }
            int responseLength = this.tools.getLengthFromFileHeader(Arrays.copyOfRange(rapdu, 0, 4));
            System.out.println("Response length : ".concat(String.valueOf(responseLength)));
            int startToReadFrom = 3;
            if (responseLength <= 127) {
                startToReadFrom = 3;
            } else if (responseLength <= 255) {
                startToReadFrom = 4;
            } else if (responseLength <= 65535) {
                startToReadFrom = 5;
            } else {
                System.out.println("Too big");
                return null;
            }
            byte[] encryptedPayload = Arrays.copyOfRange(rapdu, startToReadFrom, startToReadFrom - 1 + responseLength);
            byte[] decryptedPayload = this.decrypt(this.sessionEncKey, encryptedPayload);
            byte[] unpadedResult = this.tools.unpadData(decryptedPayload);
            return unpadedResult;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.out.println(Log.getStackTraceString((Throwable)e));
            if (TagProvider.getTagIsLost() && this.progressListener != null && this.progressListener.get() instanceof ProgressListenerInterface) {
                ((ProgressListenerInterface)this.progressListener.get()).cancel();
            }
            return null;
        }
    }
}

