/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.BitiMRTD.Tools;

import nashid.verify.sdk.mrtd2.BitiMRTD.Tools.AES;

public class AESCMAC {
    private static final byte Rb64 = 27;
    private static final byte Rb128 = -121;

    public static byte[] get(byte[] key, byte[] data) {
        byte[] zeros = null;
        zeros = new byte[16];
        return AESCMAC.get(key, data, zeros);
    }

    public static byte[] get(byte[] key, byte[] data, byte[] aesIv) {
        int blockSize = -1;
        byte rb = -1;
        byte[] nistL = null;
        blockSize = 16;
        rb = -121;
        byte[] zeros16 = new byte[blockSize];
        nistL = AES.encrypt(zeros16, key, zeros16);
        byte[] nistK1 = AESCMAC.getSubK1(nistL, blockSize, rb);
        byte[] nistK2 = AESCMAC.getSubK2(nistK1, blockSize, rb);
        return AESCMAC.getCMAC(key, nistK1, nistK2, data, aesIv, blockSize);
    }

    private static byte[] getCMAC(byte[] k, byte[] k1, byte[] k2, byte[] block, byte[] eIv, int size) {
        byte[] newBlock = block;
        if (block.length == 0) {
            newBlock = new byte[size];
            newBlock[0] = -128;
        }
        if (block.length % size != 0) {
            int index = block.length;
            newBlock = new byte[block.length - block.length % size + size];
            System.arraycopy(block, 0, newBlock, 0, block.length);
            newBlock[index] = -128;
        }
        if (block.length != 0 && block.length % size == 0) {
            for (i = newBlock.length - size; i < newBlock.length; ++i) {
                int n = i;
                newBlock[n] = (byte)(newBlock[n] ^ k1[i - newBlock.length + size]);
            }
        } else {
            for (i = newBlock.length - size; i < newBlock.length; ++i) {
                int n = i;
                newBlock[n] = (byte)(newBlock[n] ^ k2[i - newBlock.length + size]);
            }
        }
        byte[] formattedMessage = null;
        formattedMessage = AES.encrypt(eIv, k, newBlock);
        byte[] cmac = new byte[size];
        System.arraycopy(formattedMessage, formattedMessage.length - size, cmac, 0, size);
        return cmac;
    }

    private static byte[] getSubK2(byte[] k1, int size, byte poly) {
        byte[] rb = new byte[size];
        rb[rb.length - 1] = poly;
        byte[] k2 = AESCMAC.shiftLeft(k1);
        if ((k1[0] & 0x80) != 0) {
            for (int i = 0; i < size; ++i) {
                k2[i] = (byte)(k2[i] ^ rb[i]);
            }
        }
        return k2;
    }

    private static byte[] getSubK1(byte[] l, int size, byte poly) {
        byte[] rb = new byte[size];
        rb[rb.length - 1] = poly;
        byte[] k1 = AESCMAC.shiftLeft(l);
        if ((l[0] & 0x80) != 0) {
            for (int i = 0; i < size; ++i) {
                k1[i] = (byte)(k1[i] ^ rb[i]);
            }
        }
        return k1;
    }

    private static byte[] shiftLeft(byte[] a) {
        return AESCMAC.toByte(AESCMAC.shiftLeft(AESCMAC.toBit(a)));
    }

    private static byte[] toByte(String s) {
        byte[] a = new byte[s.length() / 8];
        int index = 0;
        for (int i = 0; i < s.length(); i += 8) {
            a[index] = (byte)Integer.parseInt(s.substring(i, i + 8), 2);
            ++index;
        }
        return a;
    }

    private static String shiftLeft(String s) {
        return s.substring(1) + "0";
    }

    private static String toBit(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            String s = Integer.toBinaryString(256 + b);
            sb.append(s.subSequence(s.length() - 8, s.length()));
        }
        return sb.toString();
    }
}

