/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Debug;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.util.List;
import nashid.verify.sdk.NashidSDK;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivitySelectDocumentBinding;
import nashid.verify.sdk.internetutility.ErrorUtility;
import nashid.verify.sdk.mrtd2.activity.BaseActivity;
import nashid.verify.sdk.mrtd2.activity.DocumentTypeListAdapter;
import nashid.verify.sdk.mrtd2.activity.InstructionScreenActivity;
import nashid.verify.sdk.mrtd2.activity.SettingScreenActivity;
import nashid.verify.sdk.mrtd2.activity.StartScanningActivity;
import nashid.verify.sdk.mrtd2.activity.TextSizeConverter;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;
import nashid.verify.sdk.utility.PermissionHelper;
import nashid.verify.sdk.utility.SharePreferenceUtility;

public class SelectDocumentActivity
extends BaseActivity
implements AdapterView.OnItemSelectedListener {
    private String selectedDocType;
    private String[] docArray;
    private ActivitySelectDocumentBinding binding;
    private final String[] arr = new String[]{"android.permission.CAMERA"};
    private final int REQUEST_CODE_ASK_PERMISSIONS = 100;
    final int[] checkedItem = new int[]{0};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RootedCheck.getInstance().setFlag((Activity)this);
        this.binding = ActivitySelectDocumentBinding.inflate(this.getLayoutInflater());
        RelativeLayout view = this.binding.getRoot();
        this.setContentView((View)view);
        int adb = Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"adb_enabled", (int)0);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog((Activity)this, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
            SVG svg = null;
            try {
                svg = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.name_icon);
                this.binding.icon.setSVG(svg);
            }
            catch (SVGParseException sVGParseException) {}
        } else {
            this.initView();
            this.initClickListner();
        }
    }

    private void setTexViewTextSize() {
        TextSizeConverter textSizeConverter = new TextSizeConverter(this.getApplicationContext());
        textSizeConverter.changeStatusBarColor((Activity)this);
        ViewGroup.LayoutParams layoutParams1 = this.binding.imgCurrentCountry.getLayoutParams();
        layoutParams1.width = textSizeConverter.getWidth(24);
        layoutParams1.height = textSizeConverter.getHeight(16);
        this.binding.imgCurrentCountry.setLayoutParams(layoutParams1);
        ViewGroup.LayoutParams layoutParams2 = this.binding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgSetting.setLayoutParams(layoutParams2);
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(6), 0, 0);
        this.binding.lytCountry.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        this.binding.layoutMain.setPadding(padding, padding, padding, padding);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(30), 0, 0);
        this.binding.txtChooseDoc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        this.binding.txtDesc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        LinearLayout.LayoutParams recyclerviewRayoutParams = (LinearLayout.LayoutParams)this.binding.recyclerDocType.getLayoutParams();
        recyclerviewRayoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(24), 0, 0);
        this.binding.recyclerDocType.setLayoutParams((ViewGroup.LayoutParams)recyclerviewRayoutParams);
        this.binding.txtChooseDoc.setTextSize(0, new TextSizeConverter(this.getApplicationContext()).getTextSize(32));
        this.binding.txtDesc.setTextSize(0, new TextSizeConverter(this.getApplicationContext()).getTextSize(16));
        this.binding.txtLang.setTextSize(0, new TextSizeConverter(this.getApplicationContext()).getTextSize(16));
        layoutParams2 = this.binding.imageArrow.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(16);
        layoutParams2.height = textSizeConverter.getHeight(16);
        this.binding.imageArrow.setLayoutParams(layoutParams2);
        recyclerviewRayoutParams = (LinearLayout.LayoutParams)this.binding.imageArrow.getLayoutParams();
        recyclerviewRayoutParams.setMargins(textSizeConverter.getPaddingORMarginValue(6), 0, 0, 0);
        this.binding.imageArrow.setLayoutParams((ViewGroup.LayoutParams)recyclerviewRayoutParams);
    }

    public static boolean isDebuggable(Context context) {
        return Debug.isDebuggerConnected();
    }

    private void initClickListner() {
        this.binding.langPicker.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelectDocumentActivity.this.openSelectLanguageDialog();
            }
        });
        this.binding.docDropdown.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.binding.imgSetting.setOnClickListener(view -> {
            Intent i = new Intent((Context)this, SettingScreenActivity.class);
            this.startActivity(i);
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        });
        this.binding.verification.setOnClickListener(v -> PermissionHelper.INSTANCE.requestPermissions((FragmentActivity)this, new PermissionHelper.PermissionCallback(){

            @Override
            public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                if (allGranted) {
                    SelectDocumentActivity.this.openScanDocumentScreen();
                } else {
                    Toast.makeText((Context)SelectDocumentActivity.this.getApplicationContext(), (CharSequence)"These permissions are denied: $deniedList", (int)1).show();
                }
            }
        }));
    }

    private void openScanDocumentScreen() {
        if (!this.isInternetAvailable()) {
            ErrorUtility.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
        } else {
            if (SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_verification_step))) {
                Intent i = new Intent((Context)this, InstructionScreenActivity.class);
                i.putExtra(this.getResources().getString(R.string.doc_key), this.selectedDocType);
                this.startActivity(i);
            } else {
                Intent i = new Intent((Context)this, StartScanningActivity.class);
                i.putExtra(this.getResources().getString(R.string.doc_key), this.selectedDocType);
                this.startActivity(i);
            }
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        }
    }

    private void initView() {
        this.setTexViewTextSize();
        if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(this.getString(R.string.default_name))) {
            if (!this.isInternetAvailable()) {
                ErrorUtility.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
            }
            this.docArray = this.getResources().getStringArray(R.array.docTypes);
            ArrayAdapter aa = new ArrayAdapter((Context)this, 17367048, (Object[])this.docArray);
            aa.setDropDownViewResource(0x1090009);
            this.binding.docDropdown.setAdapter((SpinnerAdapter)aa);
            try {
                SVG setting = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.img_setting);
                this.binding.imgSetting.setSVG(setting);
                SVG svg = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.name_icon);
                this.binding.icon.setSVG(svg);
                SVG one = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.dropbox);
                this.binding.dropbox.setSVG(one);
                SVG two = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.dropbox);
                this.binding.dropbox2.setSVG(two);
                SVG three = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.dropbox);
                this.binding.dropbox3.setSVG(three);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.loadAllIcon();
            }
            catch (SVGParseException sVGParseException) {
                // empty catch block
            }
        }
    }

    private void loadAllIcon() throws SVGParseException {
        SVG current_country = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.oman_flag);
        this.binding.imgCurrentCountry.setSVG(current_country);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getApplicationContext(), 1, false);
        this.binding.recyclerDocType.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        DocumentTypeListAdapter documentTypeListAdapter = new DocumentTypeListAdapter(this.getBaseContext(), this.getResources().getStringArray(R.array.docTypes));
        this.binding.recyclerDocType.setAdapter((RecyclerView.Adapter)documentTypeListAdapter);
        documentTypeListAdapter.setListner(docType -> {
            Log.d((String)"TAG", (String)("onDocumentItemClick: " + docType + "   " + this.getString(R.string.e_passport)));
            this.selectedDocType = docType;
            if (this.selectedDocType.equalsIgnoreCase(this.getString(R.string.e_passport)) || this.selectedDocType.equalsIgnoreCase(this.getString(R.string.id_card))) {
                PermissionHelper.INSTANCE.requestPermissions((FragmentActivity)this, new PermissionHelper.PermissionCallback(){

                    @Override
                    public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                        if (allGranted) {
                            SelectDocumentActivity.this.openScanDocumentScreen();
                        } else {
                            Toast.makeText((Context)SelectDocumentActivity.this.getApplicationContext(), (CharSequence)"These permissions are denied: $deniedList", (int)1).show();
                        }
                    }
                });
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please select document either idcard or passport", (int)0).show();
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 100) {
            if (grantResults[0] == 0) {
                this.openScanDocumentScreen();
            } else if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
                ActivityCompat.requestPermissions((Activity)this, (String[])this.arr, (int)100);
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.selectedDocType = this.docArray[position];
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private void openSelectLanguageDialog() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
        alertDialog.setTitle((CharSequence)"Language");
        CharSequence[] listItems = new String[]{"English", "Arabic"};
        if (this.getStorage().getPreferredLocale().equalsIgnoreCase("en") || this.getStorage().getPreferredLocale().equalsIgnoreCase("sys_def")) {
            this.checkedItem[0] = 0;
        } else {
            NashidSDK.getInstance().updateLocale((Activity)this, "en");
            this.checkedItem[0] = 1;
        }
        alertDialog.setSingleChoiceItems(listItems, this.checkedItem[0], (dialog, which) -> {
            this.checkedItem[0] = which;
            if (which == 1) {
                NashidSDK.getInstance().updateLocale((Activity)this, "ar");
            } else {
                NashidSDK.getInstance().updateLocale((Activity)this, "en");
            }
            this.recreate();
            dialog.dismiss();
        });
        alertDialog.setNegativeButton((CharSequence)"Cancel", (dialog, which) -> {});
        AlertDialog customAlertDialog = alertDialog.create();
        customAlertDialog.show();
    }
}

