package nashid.verify.sdk.id_card.omn;

import net.sf.scuba.util.Hex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG10File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_VISA_NUMBER = 0x2A20;
    public static final int TAG_VISA_EXPIRY_DATE = 0x4A21;
    public static final int TAG_VISA_PLACE_OF_ISSUE_ARABIC = 0xAA22;

    String visaNumber;
    String visaExpiryDate;
    String visaPlaceOfIssueArabic;

    public OmanCardDG10File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream =  new OmanCardDataInputStream(new ByteArrayInputStream(buffer));

        visaNumber = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_VISA_NUMBER));
        visaExpiryDate = Hex.toHexString(omanCardDataInputStream.getTagValue(TAG_VISA_EXPIRY_DATE));
        visaPlaceOfIssueArabic = new String(omanCardDataInputStream.getTagValue(TAG_VISA_PLACE_OF_ISSUE_ARABIC),charset);
    }

    public String getTagValue(int tag)
    {
        switch (tag){
            case TAG_VISA_NUMBER: return visaNumber;
            case TAG_VISA_EXPIRY_DATE: return visaExpiryDate;
            case TAG_VISA_PLACE_OF_ISSUE_ARABIC: return visaPlaceOfIssueArabic;
            default: break;
        }
        return null;
    }
    /*public String toString()
    {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DG10: ");
        stringBuilder.append("{\"visaNumber\": \"");stringBuilder.append(visaNumber);
        stringBuilder.append("\";\"visaExpiryDate\": \"");stringBuilder.append(visaExpiryDate);
        stringBuilder.append("\";\"visaPlaceOfIssueArabic\": \"");stringBuilder.append(visaPlaceOfIssueArabic);
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }*/

    @Override
    public String toString() {
        return "OmanCardDG10File{" +
                ""+TAG_VISA_NUMBER+"='" + visaNumber + '\'' +
                ", "+TAG_VISA_EXPIRY_DATE+"='" + visaExpiryDate + '\'' +
                ", "+TAG_VISA_PLACE_OF_ISSUE_ARABIC+"='" + visaPlaceOfIssueArabic + '\'' +
                '}';
    }

    public String getVisaNumber() {
        return visaNumber;
    }

    public void setVisaNumber(String visaNumber) {
        this.visaNumber = visaNumber;
    }

    public String getVisaExpiryDate() {
        return visaExpiryDate;
    }

    public void setVisaExpiryDate(String visaExpiryDate) {
        this.visaExpiryDate = visaExpiryDate;
    }

    public String getVisaPlaceOfIssueArabic() {
        return visaPlaceOfIssueArabic;
    }

    public void setVisaPlaceOfIssueArabic(String visaPlaceOfIssueArabic) {
        this.visaPlaceOfIssueArabic = visaPlaceOfIssueArabic;
    }
}
