package nashid.verify.sdk.mrtd2.activity

import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.viewpager2.widget.ViewPager2
import com.caverock.androidsvg.SVG
import com.caverock.androidsvg.SVGParseException
import com.google.android.material.tabs.TabLayoutMediator
import nashid.verify.sdk.OtherConstant
import nashid.verify.sdk.R
import nashid.verify.sdk.Utility
import nashid.verify.sdk.databinding.ActivityComparisionSuccessfulBinding
import nashid.verify.sdk.mrtd2.activity.viewmodel.ComparisonViewModel
import nashid.verify.sdk.mrtd2.rooted.RootedCheck
import nashid.verify.sdk.networking.APIClient
import nashid.verify.sdk.networking.APIInterface
import nashid.verify.sdk.networking.models.ValidationResponse
import nashid.verify.sdk.utility.SharePreferenceUtility
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class ComparisionSuccessful : BaseActivity() {
    private lateinit var binding: ActivityComparisionSuccessfulBinding
    private var viewModel: ComparisonViewModel? = null
    private var liveness = false
    private var nfc = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityComparisionSuccessfulBinding.inflate(layoutInflater)
        setContentView(binding.root)
        viewModel = ViewModelProvider(this)[ComparisonViewModel::class.java]
        RootedCheck.getInstance().setFlag(this)

        initView()
        initClick()

        observeViewModel()
    }

    private fun initView() {
        viewModel?.checkRootedStatus(applicationContext)
        setLayoutAndTextSize()
    }

    private fun observeViewModel() {
        viewModel?.isRooted?.observe(this) { isRooted ->
            if (isRooted) {
                RootedCheck.getInstance().showRootedDeviceDialog(
                    this,
                    getString(R.string.root_dialog),
                    getString(R.string.root_desc),
                    getString(R.string.root_btn),
                )
            } else {
                validateUser3()
            }
        }
    }

    @SuppressLint("InflateParams")
    private fun setupViewPager(
        fragments: Array<Fragment>,
        fragmentTitles: Array<String>,
    ) {
        binding.viewPager.adapter = ViewPagerAdapter(this, fragments, fragmentTitles)
        binding.viewPager.offscreenPageLimit = 3
        binding.tabLayout.isTabIndicatorFullWidth = false
        TabLayoutMediator(binding.tabLayout, binding.viewPager) { tab, position ->
            val customTabView = LayoutInflater.from(this).inflate(R.layout.item_tab, null)
            val tabTextView = customTabView.findViewById<TextView>(R.id.txt_tab_textview)
            val imIndicator = customTabView.findViewById<ImageView>(R.id.img_indicator)
            tabTextView.text = fragmentTitles[position]
            tab.customView = customTabView

            val selectedColor = ContextCompat.getColor(applicationContext, R.color.tab_selected)
            val unselectedColor = ContextCompat.getColor(applicationContext, R.color.tab_unselected)
            tabTextView.setTextColor(unselectedColor)
            val textSizeConverter = TextSizeConverter(applicationContext)
            tabTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(14))
            tabTextView.addOnAttachStateChangeListener(
                object : View.OnAttachStateChangeListener {
                    override fun onViewAttachedToWindow(v: View) {
                        if (tab.isSelected) {
                            tabTextView.setTextColor(selectedColor)
                            imIndicator.visibility = View.VISIBLE
                        }
                    }

                    override fun onViewDetachedFromWindow(v: View) {}
                },
            )
            tabTextView.setOnClickListener { tab.select() }
        }.attach()
    }

    private fun setLayoutAndTextSize() {
        val textSizeConverter = TextSizeConverter(applicationContext)
        textSizeConverter.changeStatusBarColor(this)
        val layoutParams = textSizeConverter.linearLayoutParam
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0)
        binding.layoutHeader.lytHeaderMain.layoutParams = layoutParams
        val padding = textSizeConverter.getPaddingORMarginValue(16)
        binding.layoutHeader.lytHeaderMain.setPadding(padding, padding, padding, 0)
        val layoutParams2 = binding.layoutHeader.imgBack.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.layoutHeader.imgBack.layoutParams = layoutParams2
        binding.layoutHeader.txtHelp.text = getString(R.string.results)
        binding.layoutHeader.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(17),
        )
        try {
            val back = SVG.getFromResource(resources, R.raw.home)
            binding.layoutHeader.imgBack.setSVG(back)
        } catch (e: SVGParseException) {
            e.printStackTrace()
        }
        val marginLayoutParams = binding.tabLayout.layoutParams as LinearLayout.LayoutParams
        marginLayoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(28), 0, 0)
        binding.tabLayout.layoutParams = marginLayoutParams
    }

    override fun onDestroy() {
        super.onDestroy()
        Utility.getInstance().cleanup()
    }

    private fun initClick() {
        val selectedColor = ContextCompat.getColor(applicationContext, R.color.tab_selected)
        val unselectedColor = ContextCompat.getColor(applicationContext, R.color.tab_unselected)
        binding.viewPager.registerOnPageChangeCallback(
            object : ViewPager2.OnPageChangeCallback() {
                override fun onPageSelected(position: Int) {
                    for (i in 0 until binding.tabLayout.tabCount) {
                        val tab = binding.tabLayout.getTabAt(i)
                        tab?.customView?.findViewById<TextView>(R.id.txt_tab_textview)?.apply {
                            setTextColor(if (i == position) selectedColor else unselectedColor)
                        }
                        tab?.customView?.findViewById<ImageView>(R.id.img_indicator)?.visibility =
                            View.GONE
                    }
                }
            },
        )
        binding.layoutHeader.imgBack.setOnClickListener {
            val intent = Intent(this, SelectDocumentActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
            startActivity(intent)
            finish()
        }
    }

    private fun validateUser3() {
        APIClient
            .getClient("validationKey", OtherConstant.getInstance().mainBaseUrl)
            .create(
                APIInterface::class.java,
            ).validateKey(resources.getString(R.string.success_completion_action))
            .enqueue(
                object : Callback<ValidationResponse?> {
                    override fun onResponse(
                        call: Call<ValidationResponse?>,
                        response: Response<ValidationResponse?>,
                    ) {
                        if (response.code() != 200) {
                            val intent =
                                Intent(this@ComparisionSuccessful, SelectDocumentActivity::class.java)
                            intent.flags =
                                Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
                            startActivity(intent)
                        } else {
                            liveness =
                                SharePreferenceUtility.getSavePreferenceData(
                                    applicationContext,
                                    getString(R.string.sharepreference_facila_matching),
                                )
                            nfc =
                                SharePreferenceUtility.getSavePreferenceData(
                                    applicationContext,
                                    getString(R.string.sharepreference_nfc),
                                )
                            viewModel?.setFragments(
                                liveness,
                                nfc,
                                storage.getPreferredLocale(),
                                applicationContext,
                            )
                            viewModel?.fragments?.observe(this@ComparisionSuccessful) { fragments ->
                                viewModel?.fragmentTitles?.observe(this@ComparisionSuccessful) { fragmentTitles ->
                                    setupViewPager(fragments, fragmentTitles)
                                }
                            }
                        }
                    }

                    override fun onFailure(
                        call: Call<ValidationResponse?>,
                        t: Throwable,
                    ) {}
                },
            )
    }
}
