package nashid.verify.sdk.mrtd2.activity;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.TypedValue;
import android.view.ViewGroup;

import androidx.annotation.Nullable;

import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import nashid.verify.sdk.NashidSDK;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivitySplashBinding;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;

public class SplashScreenActivity extends BaseActivity {

    private ActivitySplashBinding activitySplashBinding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activitySplashBinding = ActivitySplashBinding.inflate(getLayoutInflater());
        setContentView(activitySplashBinding.getRoot());
        RootedCheck.getInstance().setFlag(SplashScreenActivity.this);
        OtherConstant.getInstance().setAppname();
        if (RootedCheck.getInstance().isRootedDevice(getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(this, getString(R.string.root_dialog), getString(R.string.root_desc), getString(R.string.root_btn));
        } else {
            initView();
        }

    }

    private void initView() {

        new TextSizeConverter(getApplicationContext()).changeStatusBarColor(SplashScreenActivity.this);
// Set the desired width and height in sp
        int desiredWidthInSp = 200;
        int desiredHeightInSp = 54;

// Convert sp to pixels
        float scale = getResources().getDisplayMetrics().scaledDensity;
        int desiredWidthInPixels = (int) (desiredWidthInSp * scale + 0.5f);
        int desiredHeightInPixels = (int) (desiredHeightInSp * scale + 0.5f);

// Set the new LayoutParams with the desired width and height
        ViewGroup.LayoutParams layoutParams = activitySplashBinding.imageSplash.getLayoutParams();
        layoutParams.width = desiredWidthInPixels;
        layoutParams.height = desiredHeightInPixels;
        activitySplashBinding.imageSplash.setLayoutParams(layoutParams);

        SVG svg = null;
        try {
//            Log.d("TAG", "attachBaseContext:splash ");
//            getPreferredLocale(getApplicationContext());
            if (getStorage().getPreferredLocale().equalsIgnoreCase("ar")) {
                svg = SVG.getFromResource(getResources(), R.raw.splash_icon_ar);
            }else{
                svg = SVG.getFromResource(getResources(), R.raw.splash_icon);
            }
            activitySplashBinding.imageSplash.setSVG(svg);
        } catch (SVGParseException e) {

        }

        activitySplashBinding.txtBottom.setTextSize(TypedValue.COMPLEX_UNIT_PX, new TextSizeConverter(getApplicationContext()).getTextSize(18));
        new Handler().postDelayed(() -> {

            Intent intent = new Intent(SplashScreenActivity.this, SelectDocumentActivity.class);
            startActivity(intent);
            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
           /* Bitmap croppedImageBitmap= BitmapFactory.decodeResource(getResources(),R.drawable.photot);
            croppedImageBitmap=(Bitmap.createScaledBitmap(croppedImageBitmap, 120, 120, false));
            Intent intent = new Intent(SplashScreenActivity.this, SkipNFCLivnessActivity.class);
            intent.putExtra(getResources().getString(R.string.doc_key), "E-passport");
            intent.putExtra("BitmapImage", croppedImageBitmap);
            startActivity(intent);
            finish();*/
        }, 1000);


    }

}
